/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.AWS;
import org.rhwlab.LMS.RNASeq.AlignmentID;
import org.rhwlab.LMS.RNASeq.AlignmentIDs;
import org.rhwlab.LMS.RNASeq.ExpressBy;
import org.rhwlab.LMS.RNASeq.ExpressionDirectory;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.RNASeq.views.MatrixDisplayFrame;
import org.rhwlab.LMS.dialogs.AddConditionDialog;
import org.rhwlab.LMS.dialogs.AddTimeSeriesDialog;
import org.rhwlab.LMS.dialogs.ExportExpressionValuesDialog;
import org.rhwlab.LMS.dialogs.ExportGeneExpressionDialog;
import org.rhwlab.LMS.views.LabMan;
import static org.rhwlab.LMS.views.RNASeq.AlignmentPanel.upload;
import org.rhwlab.LMS.views.TransferMenuItem;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class ExpressionPanel extends TrackingPanel implements ActionListener{

    public ExpressionPanel() {
        super(false, inits);
        buildMenu();
        if (labelMap == null){
            labelMap = new HashMap<>();
            labelMap.put(all, "transcript");
            labelMap.put(mRNA, "mRNA.transcript");
            labelMap.put(genes, "mRNA.gene");
            labelMap.put(steep, "steep.mRNA.gene");
        }
        frame = new MatrixDisplayFrame();
    }
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("Expression");   
        
        TransferMenuItem copyRecs = new TransferMenuItem("Copy Record(s)","Expression",ExpressionPanel.this);
        menu.add(copyRecs); 
        
        JMenuItem express = new JMenuItem(expressionItem);
        express.addActionListener(this);
        menu.add(express); 

        JMenuItem group = new JMenuItem(groupReps);
        group.addActionListener(this);
        menu.add(group); 
        
        JMenuItem tsItem = new JMenuItem(formTS);
        tsItem.addActionListener(this);
        menu.add(tsItem);  
        
        JMenu spear = new JMenu(spearman);
        menu.add(spear); 
        
        JMenuItem allTranscripts = new JMenuItem(all);
        allTranscripts.addActionListener(this);
        spear.add(allTranscripts);
        
        JMenuItem mRNATranscripts = new JMenuItem(mRNA);
        mRNATranscripts.addActionListener(this);
        spear.add(mRNATranscripts);        
        
        JMenuItem mRNAGenes = new JMenuItem(genes);
        mRNAGenes.addActionListener(this);
        spear.add(mRNAGenes);
        
        JMenuItem steepGenes = new JMenuItem(steep);
        steepGenes.addActionListener(this);
        spear.add(steepGenes);
        
        JMenuItem exportItem = new JMenuItem(export);
        exportItem.addActionListener(this);
        menu.add(exportItem);    
  
        JMenuItem exportGenesItem = new JMenuItem(exportGenes);
        exportGenesItem.addActionListener(this);
        menu.add(exportGenesItem); 
        
        JMenuItem summaryItem = new JMenuItem(summary);
        summaryItem.addActionListener(this);
        menu.add(summaryItem);
        
        JMenuItem finishItem = new JMenuItem(finish);
        finishItem.addActionListener(this);
        menu.add(finishItem);

        JMenuItem dccFileUpload = new JMenuItem(upload);
        dccFileUpload.addActionListener(this);
        menu.add(dccFileUpload);
        
/*        
        JMenuItem monocleItem = new JMenuItem(monocle);
        monocleItem.addActionListener(this);
        menu.add(monocleItem);
        

 */       
    }    
   
    public boolean canCalculateExpression(int row){
        String expID = this.getValue(row,"ExpressionID");
        if (this.getValue(row,"ExpressionBy").equals("")){
            JOptionPane.showMessageDialog(this,String.format("Must specify ExpressionBy for %s\nNo calculations submitted",expID));
            return false;
        }
        if (this.getValue(row,"Reference").equals("")){
            JOptionPane.showMessageDialog(this,String.format("Must specify Reference for %s\nNo calculations submitted",expID));
            return false;
        } 
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();

        if (e.getActionCommand().equals(expressionItem)){
            for (int row : rows){
                if (!this.canCalculateExpression(row)){
                    return;
                }
            }            
            int expressColumn = this.getConfig().getColumn("ExpressionBy");
            for (int i=0 ; i<rows.length ;++i){
                ExpressBy express = (ExpressBy)this.getModel().getValueAt(rows[i],expressColumn);
                try {
                    express.submit();
                    this.updateDB();
                    Thread.sleep(300);
                }catch (Exception exc){
                    exc.printStackTrace();
                }

            }   
        } 
        else if (e.getActionCommand().equals(all)||e.getActionCommand().equals(mRNA)||e.getActionCommand().equals(genes)||e.getActionCommand().equals(steep)){
            String[] ids = new String[rows.length];
            for (int i=0 ; i<rows.length ; ++i) {
                ids[i] = this.getValue(rows[i], "LibraryID");
            }
            int dirColumn = this.getConfig().getColumn("Directory");
            ExpressionDirectory[] dirs = new ExpressionDirectory[rows.length];
            for (int i=0 ; i<rows.length ; ++i){
                dirs[i] = (ExpressionDirectory)this.getModel().getValueAt(rows[i], dirColumn);
            }
            try {
                double[][] spears = ExpressionDirectory.autoSpearman(dirs,labelMap.get(e.getActionCommand()));
                frame.addTab(ids,ids,spears,e.getActionCommand());
                frame.setVisible(true);
            } catch (Exception exc){
                exc.printStackTrace();
            }
        }
        else if (e.getActionCommand().equals(groupReps)){
            if (this.conditionDialog==null){
                this.conditionDialog = new AddConditionDialog(this);
            }
            if (rows.length < 2){
                JOptionPane.showMessageDialog(this,"Select at least 2 replicates for the condition");
                return;
            }  
            // all the expression calculations need to be using the same program
            String first = this.getValue(rows[0], "ExpressionBy");
            for (int i=0 ; i<rows.length ; ++i){
                String next = this.getValue(rows[i], "ExpressionBy");
                if (!next.equals(first)){
                    JOptionPane.showMessageDialog(LabMan.labMan,"All the expression calculations need to be done with the same program");
                    return;
                }
            }
            // all the expression calculations need to be using the same reference
            first = this.getValue(rows[0], "Reference");
            for (int i=0 ; i<rows.length ; ++i){
                String next = this.getValue(rows[i], "Reference");
                if (!next.equals(first)){
                    JOptionPane.showMessageDialog(LabMan.labMan,"All the expression calculations need to be done with the same reference");
                    return;
                }
            }            
            this.conditionDialog.setVisible(true);
            try {
                this.conditionDialog.init();
            }catch (Exception exc){
                exc.printStackTrace();
            }
        }    
        else if (e.getActionCommand().equals(formTS)){
            if (this.tsDialog==null){
                this.tsDialog = new AddTimeSeriesDialog(this);
            }
            if (rows.length < 2){
                JOptionPane.showMessageDialog(this,"Select at least 2 expression calculations for the time series");
                return;
            }  
            // all the expression calculations need to be using the same program
            String first = this.getValue(rows[0], "ExpressionBy");
            for (int i=0 ; i<rows.length ; ++i){
                String next = this.getValue(rows[i], "ExpressionBy");
                if (!next.equals(first)){
                    JOptionPane.showMessageDialog(LabMan.labMan,"All the expression calculations need to be done with the same program");
                    return;
                }
            }
            
            this.tsDialog.setVisible(true);
            this.tsDialog.init();
        } 
        else if (e.getActionCommand().equals(export)){
            if (rows.length < 1){
                JOptionPane.showMessageDialog(this,"Select at least one time series");
                return;
            }             
            if (exportDialog == null){
                this.exportDialog = new ExportExpressionValuesDialog(this);
            }
            this.exportDialog.init();
            this.exportDialog.setVisible(true);
        }       
        else if (e.getActionCommand().equals(exportGenes)){
            if (rows.length < 1){
                JOptionPane.showMessageDialog(this,"Select at least one time series");
                return;
            }             
            if (exportGeneDialog == null){
                this.exportGeneDialog = new ExportGeneExpressionDialog(this);
            }
            this.exportGeneDialog.init();
            this.exportGeneDialog.setVisible(true);
        }          
        else if (e.getActionCommand().equals(finish)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    Finisher finish = new Finisher(this.getValue(rows[i],"ExpressionID"),"BitSeq");
                    finish.setDir(this.getValue(rows[i],"Directory"));
                    finish.init();
                    finish.run();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        } 
        if (e.getActionCommand().equals(summary)){
            int idsColumn = this.getConfig().getColumn("AlignmentIDs");
            LinkedHashMap<String,TreeMap<String,LinkedHashMap<String,Integer>>> expMap = new LinkedHashMap<>();
            for (int i=0 ; i<rows.length ;++i){
                String expID = this.getValue(rows[i],"ExpressionID");
                AlignmentIDs ids = (AlignmentIDs)this.getModel().getValueAt(rows[i],idsColumn);
                try {
                   
                   expMap.put(expID,AlignmentID.readReport(ids.getIDs()));
                   int uasdfuish=0;
                }catch (Exception exc){
                    exc.printStackTrace();
                }

            }
            
            // report the summary
            String[] labels = null;
            PrintStream stream = System.out;
            stream.print("Counts");
            for (String expID : expMap.keySet()){
                stream.printf("\t%s", expID);
                if (labels == null){
                    TreeMap<String,LinkedHashMap<String,Integer>> alignMap = expMap.get(expID);
                    LinkedHashMap<String,Integer> labelMap = alignMap.get(alignMap.firstKey());
                    labels = labelMap.keySet().toArray(new String[0]);
                }
            }
            stream.println();
            
            for (String label : labels){
                stream.printf("%s", label);
                for (String expID : expMap.keySet()){
                    TreeMap<String,LinkedHashMap<String,Integer>> alignMap = expMap.get(expID);
                    int total = 0;
                    for (String alignID : alignMap.keySet()){
                        LinkedHashMap<String,Integer> labelMap = alignMap.get(alignID);
                        total = total + labelMap.get(label);
                    }
                    stream.printf("\t%d", total);
                }
                stream.println();
            }
        } 
        else if (e.getActionCommand().equals(upload)){
            String server = this.getConfig().getJsonConfig("file").getServer();
            for (int i=0 ; i<rows.length ; ++i){
                int idColumn = this.getConfig().getColumn("DCCResponse");
                AWS id  = (AWS)this.getModel().getValueAt(rows[i],idColumn);   
                try {
                    id.submitExpression(server);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }        
    }
    ExportExpressionValuesDialog exportDialog;
    ExportGeneExpressionDialog exportGeneDialog;
    AddConditionDialog conditionDialog;
    AddTimeSeriesDialog tsDialog;
    MatrixDisplayFrame frame;
    static String[] inits = {"Pending"};
    static String expressionItem ="Submit Expression Calculation";
    static String spearman = "Spearman Correlations";
    static String all = "All Transcripts";
    static String mRNA = "mRNA Transcripts";
    static String genes = "mRNA Genes";
    static String steep = "Steep mRNA Genes";
    static String finish = "Update post process";
    static String groupReps = "Form a Condition (Group Replicates)";
    static String formTS = "Form a Time Series (Group Expression Calculations)";
    static String export ="Export Transcript Expression Values";
    static String exportGenes ="Export Gene Expression Values";
    static String summary ="Read Summary Report";
    static String upload  = "Upload CSV to the DCC";
    static HashMap<String,String> labelMap = null;
    
}
