/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.event.ChangeListener;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.rhwlab.LMS.report.ReportPanel;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.report.config.Report;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class LabMan extends JFrame {
    public LabMan(Object[] xmls) throws Exception {
        gridMemory = new TreeMap<>();
        gridMemory.put("Alignment",20);
        gridMemory.put("Merge",20);
        gridMemory.put("Seldup",32);
        gridMemory.put("RemoveDup",32);
        gridMemory.put("BitSeq",16);
        gridMemory.put("HTSeq",16);
        
        this.setTitle("Lab Management DataBase");
        String lf = UIManager.getCrossPlatformLookAndFeelClassName();
        LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (LookAndFeelInfo info : infos){
            String name = info.getName();
            int jj=0;
        }
        UIManager.setLookAndFeel(lf);
        this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        this.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent event){
                try {
                if (exitFrame()) {
                    dispose();
                    System.exit(0);
                }
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        
        tabbed  = new JTabbedPane();

        toolBar = new FindToolBar();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(tabbed,BorderLayout.CENTER);
        mainPanel.add(toolBar,BorderLayout.SOUTH);
        this.setContentPane(mainPanel);
        
        // listens to changes in the tab selected
        tabbed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int savePanel = selectedPanel;
                selectedPanel = tabbed.getSelectedIndex();
                if (selectedPanel != -1){
                    JPanel tabPanel = (JPanel)tabbed.getComponentAt(selectedPanel);
                    if (tabPanel instanceof SpreadSheetPanel){
                        SpreadSheetPanel ssPanel = (SpreadSheetPanel)tabPanel;
                        buildMenu(); 
                        ssPanel.cellSelection(byCell.isSelected());
                        toolBar.usePanel(ssPanel);
                    }
                }
                
                if (selectedPanel != -1) 
                if (spreadSheetPanels.isEmpty()) return;
                if (savePanel == -1) return;
                try {
                    exitPanel(savePanel);
                } catch (Exception exc){
                    exc.printStackTrace();
                    System.exit(0);
                }
            }
        });
        
        // build all the panels
        SAXBuilder saxBuilder = new SAXBuilder();
        for (Object xml : xmls){
            Document doc;
            if (xml instanceof String){
                doc = saxBuilder.build(new File((String)xml)); 
            } else {
                doc = saxBuilder.build((InputStream)xml);
            }
            Element ssElement = doc.getRootElement();  
            
            if (ssElement.getName().equals("SpreadSheet")){
                SpreadSheet config = new SpreadSheet(ssElement);
                SpreadSheetPanel panel = config.newPanel();
                
                spreadSheetPanels.add(panel);
                panel.setConfig(config);
                panel.addGridParametersMenu();
                panel.addJsonToMenu();
                panel.addGridErrorUpdateToMenu();
                tabbed.addTab(config.getTitle(), panel);
            } else if (ssElement.getName().equals("Report")){
                Report report = new Report(ssElement);
                ReportPanel panel = report.newPanel();
                panel.setConfig(report);
                tabbed.addTab(report.getTitle(), panel);
            }
        }
        
        // load all the models from the DB
        for (SpreadSheetPanel panel : spreadSheetPanels){
            panel.loadModelFromDB();
        }
        buildMenu();
        ButtonGroup selGroup = new ButtonGroup();
        selGroup.add(byRow);
        byRow.setSelected(true);
        selGroup.add(byCell);     
        pack();
        setSize(1200, 500);        
    }
    private void buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        
        JMenu fileMenu = new JMenu("File");
/*        
        JMenuItem clusterItem  = new JMenuItem("Set the Compute Grid Cluster");
        fileMenu.add(clusterItem);
        clusterItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                
                grid = (String)JOptionPane.showInputDialog(LabMan.labMan,"Choose the Grid","Compute Grid Cluster",JOptionPane.INFORMATION_MESSAGE
                        ,null, grids, grid);
            }
        });
        JMenu memoryMenu  = new JMenu("Compute Grid Memory");
        fileMenu.add(memoryMenu);
        for (String program : gridMemory.keySet()){
            JMenuItem memoryItem = new JMenuItem(program);
            memoryMenu.add(memoryItem);
            memoryItem.addActionListener(new ActionListener(){
                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmd = e.getActionCommand();
                    Integer n = LabMan.gridMemory.get(cmd);
                    String mem = JOptionPane.showInputDialog(LabMan.labMan,"Memory in gigabytes",n.toString());
                    if (mem!=null){
                        try {
                            int i = Integer.valueOf(mem);
                            LabMan.gridMemory.put(cmd, i);
                            
                        } catch (Exception exc){
                            JOptionPane.showMessageDialog(LabMan.labMan,"Invalid entry - no change made");
                        }
                    }
                }
            });      
        }
        fileMenu.addSeparator();
 */       
        JMenuItem remove = new JMenuItem("Remove Selected Unsaved Rows");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                removeRows();
            }
        });
        fileMenu.add(remove);
        fileMenu.addSeparator();
        
        JMenuItem load = new JMenuItem("Load(current tab) from the DB");
        load.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    
                    if (selectedPanel!=-1){
                       spreadSheetPanels.get(selectedPanel).loadModelFromDB();
                    }
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        fileMenu.add(load);
        
        JMenuItem addRows = new JMenuItem("Add rows from a file");
        addRows.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    addRows();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        fileMenu.add(addRows);
        fileMenu.addSeparator();
        
        JMenuItem saveChanges = new JMenuItem("Save All Changes(all tabs)");
        saveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (SpreadSheetPanel panel : spreadSheetPanels){
                    try {
                        saveModel(panel);
                    } catch(Exception exc){
                        exc.printStackTrace();
                    }
                }
            }
        });
        fileMenu.add(saveChanges);
        fileMenu.addSeparator();
        
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                if (exitFrame()) {
                    dispose();
                    System.exit(0);
                }
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        fileMenu.add(exit);
        
        menuBar.add(fileMenu);
        
        JMenu selectMenu = new JMenu("Selection");
        selectMenu.add(byRow);
        byRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetPanel selPanel = spreadSheetPanels.get(selectedPanel);
                selPanel.cellSelection(false);
            }
        });        

        byCell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetPanel selPanel = spreadSheetPanels.get(selectedPanel);
                selPanel.cellSelection(true);
            }
        });
        selectMenu.add(byCell);

        menuBar.add(selectMenu);
        
        JMenu infoMenu = new JMenu("Info");
        menuBar.add(infoMenu);
        JMenuItem countItem = new JMenuItem("Record Count");
        infoMenu.add(countItem);
        countItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetPanel selPanel = spreadSheetPanels.get(selectedPanel);
                SpreadSheetModel mod = selPanel.getModel(); 
                int count = mod.getRowCount();
                String msg = String.format("Record count = %d",count);
                JOptionPane.showMessageDialog(labMan, msg);
            }
        });
        JMenuItem selectCountItem = new JMenuItem("Selection Count");
        infoMenu.add(selectCountItem);
        selectCountItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetPanel selPanel = spreadSheetPanels.get(selectedPanel);
                SpreadSheetModel mod = selPanel.getModel(); 
                int[] sels = selPanel.getSelectedRows();
                String msg = String.format("Selection count = %d",sels.length);
                JOptionPane.showMessageDialog(labMan, msg);
            }
        }); 
        JMenuItem uniqueCountItem = new JMenuItem("Unique Values Count");
        infoMenu.add(uniqueCountItem);
        uniqueCountItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetPanel selPanel = spreadSheetPanels.get(selectedPanel);
                selPanel.uniqueSelectedValues();
            }
        });
        
        if (spreadSheetPanels.size()>0){
            if (selectedPanel != -1){
                Component comp = tabbed.getSelectedComponent();
                if (comp instanceof SpreadSheetPanel){
                    SpreadSheetPanel ssPanel = (SpreadSheetPanel)comp;
                    JMenu menu = ssPanel.getMenu();
                    menuBar.add(menu);                    
                }
            }
        }
        this.setJMenuBar(menuBar);
    }
    // remove any unsaved selected rows
    private void removeRows(){
        SpreadSheetPanel selPanel = spreadSheetPanels.get(selectedPanel);
        SpreadSheetModel mod = selPanel.getModel();
        int[] rows = selPanel.getSelectedRows();

        RowSorter sorter = selPanel.getRowSorter();
        // account for table sort order
        for (int i=0 ; i<rows.length ; ++i){
            rows[i] = sorter.convertRowIndexToModel(rows[i]);
        }
        Arrays.sort(rows);
        
        for (int i=rows.length-1 ; i>=0 ; --i){
            mod.removeRow(rows[i]);
        }        
    }
    private void addRows()throws Exception {
        JFileChooser chooser = new JFileChooser();
        int result = chooser.showOpenDialog(this);
        if (result==JFileChooser.APPROVE_OPTION){
            File file = chooser.getSelectedFile();
            spreadSheetPanels.get(selectedPanel).getModel().addRowsFromFile(file);
        }
    }

    private boolean exitFrame() throws Exception {
        // check for changes that have not been saved 
        boolean changes = false;
        for (SpreadSheetPanel panel : spreadSheetPanels){
            if (panel.getModel().hasChanged()){
                changes = true;
                break;
            }
        }
        if(changes){
            int ret = JOptionPane.showOptionDialog(this,"You have unsaved changes","Unsaved Changes",JOptionPane.YES_NO_CANCEL_OPTION,
                    JOptionPane.WARNING_MESSAGE, null,options,null);
            if (ret == 0){
                for (SpreadSheetPanel panel : spreadSheetPanels){
                    if (!saveModel(panel)){
                        return false;
                    } 
                }
                return true;
            } else if (ret == 1){
                return true;
            } else {
                return false;
            }

        }
        return true;
    }
    private boolean saveModel(SpreadSheetPanel panel) throws Exception {
        SpreadSheetModel model = panel.getModel();
        if (!model.isSaveable()){
            String msg = String.format("There are incomplete records in the %s table that cannot be saved\n",panel.getTitle());

            JOptionPane.showMessageDialog(this, msg, "Incomplete Records", JOptionPane.WARNING_MESSAGE);
                return false;
        }
        panel.updateDB();
        return true;
    }
    private  void exitPanel(int p) throws Exception {
        /*
        if(panels.get(p).getModel().hasChanged()){
            String msg = String.format("Do you want to save changes made in the %s view?",panels.get(p).getTitle());
            int ret = JOptionPane.showOptionDialog(this,msg,"Unsaved Changes",JOptionPane.YES_NO_OPTION,
                    JOptionPane.WARNING_MESSAGE, null,null,null);
            if (ret == 0){
                panels.get(p).getModel().updateDb();
            }
        }
         * 
         */
    }
    public SpreadSheetPanel getPanel(String title){
        for (SpreadSheetPanel panel  : spreadSheetPanels ){
            if (title.equals(panel.getTitle())){
                return panel;
            }
        }
        return null;
    }
    public static void main(final String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
                    labMan = new LabMan(args);
                    labMan.setVisible(true); 

                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
    }
    JCheckBoxMenuItem byCell = new JCheckBoxMenuItem("Cells");
    JCheckBoxMenuItem byRow = new JCheckBoxMenuItem("Rows");
    FindToolBar toolBar;
    static public LabMan labMan;
    static Object[] grids = {"sage","waterston"};
    static public String grid = (String)grids[0];
    static public Map<String,Integer> gridMemory;
    int selectedPanel=0;
    JTabbedPane tabbed;
    static String[] options = {"Save Changes and Close","Discard Changes and Close","Cancel Closing"};
    static String[] options2 = {"Ignore Incomplete Records","Cancel Save"};
    ArrayList<SpreadSheetPanel> spreadSheetPanels = new ArrayList<SpreadSheetPanel>();
}
