/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class IntegrationPanel extends TrackingPanel{
    public IntegrationPanel(){
        super(false,inits);
        buildMenu();
    }
   
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("Integrations");  
        
        JMenuItem integration = new TransferMenuItem("To Integration","Integration",IntegrationPanel.this);
        menu.add(integration);  
        
        final TransferMenuItem addScreen = new TransferMenuItem("To Screening","Screen",IntegrationPanel.this);
        addScreen.addListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] sel = IntegrationPanel.this.getConvertedSelectedRows();
                SpreadSheetModel model = IntegrationPanel.this.getModel();
                int col = model.findColumn("ToScreening");
                Date date = new Date();
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], col);
                    base.setValue(date);
                }
            }
        });
        menu.add(addScreen);  
        
        JMenuItem pcr = new TransferMenuItem("To PCR","PCR",IntegrationPanel.this);
        menu.add(pcr);           


    }

    static String[] inits = {"Pending","Active"};

}
