/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import javax.swing.JFrame;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SeriesMetaData;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Imaged;

/**
 *
 * @author gevirl
 */
public class ImageFrame extends JFrame{
    public ImageFrame()throws Exception {
        this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        imagePanel = new ImagePanel();
        this.add(imagePanel);
    }
    public ImageFrame(String series,Imaged md,String imageDir,int maxTime) throws Exception {
        this();
        this.setTitle(series);
        SeriesEmbryo embryo = new SeriesEmbryo(MySql.getMySql(),series,"raw");
        imagePanel.setSeries(embryo,md, imageDir, maxTime);
    }
    public void setSeries(String series)throws  Exception {
        this.setTitle(series);
        SeriesMetaData md = new SeriesMetaData(MySql.getMySql(),series);
        SeriesEmbryo embryo = new SeriesEmbryo(MySql.getMySql(),series,"raw");
        imagePanel.setSeries(embryo,md, md.getImageDir(), md.getTimePoints());
    }
    ImagePanel imagePanel;
    
    static public void main(final String[] args) throws Exception{
        
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
                    Imaged md = new Imaged(args[0]);
                    
                    ImageFrame frame = new ImageFrame(args[0],md,md.getImageDir(),md.getTimePoints());
                    //Display the window.
                    frame.pack();
                    frame.setVisible(true); 
                    frame.setSize(800, 600);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });        
    }
}
