/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class HiSeqPanel extends TrackingPanel implements ActionListener {
    public HiSeqPanel(){
        super(false,inits);
        buildMenu();
    } 
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("HiSeq");  
        
        JMenuItem with = new JMenuItem("Submit Alignment with MiSeq");
        with.addActionListener(this);
        menu.add(with);
        
        JMenuItem without = new JMenuItem("Submit Alignment without MiSeq");
        without.addActionListener(this);
        menu.add(without);        
    }     

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        
        boolean with = !e.getActionCommand().contains("without");
        if (with){
            // check that MiSeq has been run on all the selected rows
        }
        
        int fastqColumn = this.getConfig().getColumn("FastqFile");
        int hiseqIDColumn = this.getConfig().getColumn("HiSeqID");
        int datasetColumn = this.getConfig().getColumn("DataSet");
        
        for (int row : rows){
            File[] fastqFiles = (File[])((CellBase)this.getModel().getValueAt(row, fastqColumn)).getValue();
            String id = ((CellBase)this.getModel().getValueAt(row, hiseqIDColumn)).getValueAsString();
            String dataSet = ((CellBase)this.getModel().getValueAt(row, datasetColumn)).getValueAsString();
            try {
                File knockdownDir = new File("/net/waterston/vol9/knockdown");
                File knockHiSeqDir = new File(knockdownDir,"HiSeq");
                
                // make the dataset directory if needed
                File datasetDir = new File(knockHiSeqDir,dataSet);;
                if (!datasetDir.exists()){
                    datasetDir.mkdir();
                }
                
                // make the alignment directory
                File hiSeqDir = new File(datasetDir,id);
                if (hiSeqDir.exists()) deleteFile(hiSeqDir);
                hiSeqDir.mkdir();
                hiSeqDir.setWritable(true, false);
                hiSeqDir.setReadable(true, false);                
                hiSeqDir.setExecutable(true, false);
                
                // build the script file for this HiSeq alignment 
                File scriptDir = new File(knockdownDir,"scripts");
                File scriptFile = new File(scriptDir,id);

                PrintWriter writer = new PrintWriter(scriptFile);
                writer.println("#! /bin/bash");
                writer.printf("cd %s\n",hiSeqDir.getPath());
                writer.printf("echo %s > seqfof\n",fastqFiles[0].getName());
                for (int i=1 ; i<fastqFiles.length;++i){
                    writer.printf("echo %s >> seqfof\n",fastqFiles[i].getName() );
                }
                for (File fastqFile : fastqFiles){
                    writer.printf("cp %s .\n", fastqFile.getPath());
                }
                writer.printf("qsub -e %s -o %s RNASEQ.qsub", hiSeqDir.getPath(),hiSeqDir.getPath());
                writer.close();
                scriptFile.setReadable(true,false);
                scriptFile.setExecutable(true, false);
                scriptFile.setWritable(true, false);    
                
                // build the qsub file that does the alignment and build the wig file
                writer = new PrintWriter(new File(hiSeqDir,"RNASEQ.qsub"));
                writer.println("#$ -S /bin/bash");
                writer.println("#$ -l mfree=16G");
                writer.printf("/nfs/waterston/transcriptome/scripts/RNASEQ_quick/RNASeqPipeline.pl %s seqfof WS230\n",hiSeqDir.getPath());
                String samtools = "/nfs/waterston/transcriptome/scripts/samtools-0.1.18/samtools";
                String ref = "/nfs/waterston/transcriptome/scripts/c_elegans.WS230.genomic.fa";
                writer.printf("cd %s\n",hiSeqDir.getPath());
                writer.printf("%s mpileup -ABIf %s  %s.WS230.merge.bam | gzip -c > %s.mpileup.gz\n",samtools,ref,id,id);
                writer.printf("/nfs/waterston/transcriptome/scripts/MakeWig.pl %s.mpileup.gz %s %s\n ",id,id,id);
                writer.print("md5sum * > md5\n");
                writer.printf("chmod -R 777 %s",hiSeqDir.getPath());
                writer.close();
                
                // start the alignment script running 
                ProcessBuilder pb = new ProcessBuilder("/net/waterston/vol9/knockdown/AlignHiSeq.sh",id);
                Process p = pb.start();   
                
                // save filename to DB
                StringBuilder builder = new StringBuilder(fastqFiles[0].getName());
                for (int i=1 ; i<fastqFiles.length ; ++i){
                    builder.append(',');
                    builder.append(fastqFiles[i].getName());
                }

                this.getModel().setValue(row,"FastqFile", builder.toString(), false);
                this.getModel().setValue(row,"AlignmentDirectory", hiSeqDir.getPath(), false);
            } catch (Exception exc){
                exc.printStackTrace();
            }
            
            int kaosdfs=0;
        }
    }
    // delete a file/directory recursively
    static void deleteFile(File file){
        if (file.isDirectory()){
            File[] files = file.listFiles();
            for (File subFile : files){
                deleteFile(subFile);
            }
        } else {
            file.delete();
        }
    }
    
static String[] inits = {"Pending"};    
}
