/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import static org.rhwlab.LMS.views.LabMan.options2;
import org.rhwlab.spreadsheet.Project;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;
import org.rhwlab.spreadsheet.config.Column;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class FindToolBar extends JToolBar {
    public FindToolBar(){
        super();
        this.add(new JLabel("Project: "));
        projectList = Project.makeBox();
        projectList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange()==ItemEvent.SELECTED) {
                if (panel instanceof TrackingPanel){
                    // check on changes to tracking
                    TrackingPanel trackPanel = (TrackingPanel)panel;
                    if(trackPanel.hasTrackingChanged()){
                        int ret = JOptionPane.showOptionDialog(LabMan.labMan,"There are unsaved tracking changes","Incomplete Records",JOptionPane.YES_NO_OPTION,
                        JOptionPane.WARNING_MESSAGE, null,options2,null);
                        if (ret == 0){
                            // save tracking changes
                            try{
                                trackPanel.updateTracking();
                            } catch (Exception exc){
                                exc.printStackTrace();
                                return;
                            }
                        }
                    }
                }
                    
                String project = (String)projectList.getSelectedItem();
                panel.setProject(project);                    
                }
            }
        });

        
        this.add(projectList);
        
        filterpanel = new FilterPanel();
        this.add(filterpanel);
        
        this.add(new JLabel("    Find: "));
        text = new JTextField();
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ke) {
                StringBuilder builder = new StringBuilder(text.getText().trim());
                builder.append(ke.getKeyChar());
                String column = (String)columnList.getSelectedItem();
                SpreadSheetModel model = panel.getModel();
                int[] rows = panel.getModelRows();
                int row = model.findRecordBeginingWithValue(column,builder.toString(),rows);
                if (row != -1) panel.moveToRow(row);
            }

        });
        this.add(text);         
        this.add(new JLabel("   In Column: "));
        this.add(columnList);
        columnList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String column = (String)columnList.getSelectedItem();
                int c = panel.getConfig().getColumn(column);
                Column col = panel.getConfig().getColumn(c);
                try {
                    filterpanel.useColumn(col);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
       
 //       this.add(new JButton("Any Column"));
        
    }
    public void usePanel(SpreadSheetPanel panel){
        this.panel = panel;
        SpreadSheet config = panel.getConfig();
        int n = config.getColumnCount();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for (int i=0 ; i<n ; ++i){
            Column column = config.getColumn(i);
            model.addElement(column.getHeader());
        }
        columnList.setModel(model);
        projectList.setSelectedItem(panel.getProject());
        filterpanel.usePanel(panel);
    }
    SpreadSheetPanel panel;
    JTextField text;
    JComboBox columnList = new JComboBox();
    JComboBox projectList;
    FilterPanel filterpanel;
    static String[] options2 = {"Save Tracking","Don't Save Tracking Changes"};
}
