/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.Filter;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.config.Column;

/**
 *
 * @author gevirl
 */
public class FilterPanel extends JPanel {
    public FilterPanel(){
        super();
        this.setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
    }
    
    public void usePanel(SpreadSheetPanel panel){
        this.panel = panel;
    }
    
    public void useColumn(Column col) throws Exception {
        this.column = col;
        this.removeAll();
        
        value1 = column.singleCellTable();
        value2 = column.singleCellTable();
        
        this.add(new JLabel("Value1: "));
        this.add(value1);
        
        this.add(new JLabel("Value2"));
        this.add(value2);
        
        filterButton = new JButton("Filter from DB");
        this.add(filterButton);
        filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTable table1 = (JTable)value1;
                CellBase base1 = (CellBase)table1.getValueAt(0, 0);
                JTable table2 = (JTable)value2;
                CellBase base2 = (CellBase)table2.getValueAt(0, 0); 
                String sql = panel.getSQL();
                Filter filter = new Filter(column.getHeader(),base1,base2);
                try {
                    panel.getModel().loadFromDb(sql,filter);      
                } catch (Exception exc){
                    exc.printStackTrace();
                }
               
            }
        });  
        
        refilterButton = new JButton("Refilter View");
        refilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table1 = (JTable)value1;
                CellBase base1 = (CellBase)table1.getValueAt(0, 0);
                JTable table2 = (JTable)value2;
                CellBase base2 = (CellBase)table2.getValueAt(0, 0); 
                String sql = panel.getSQL();
                Filter filter = new Filter(column.getHeader(),base1,base2);
                panel.getModel().refilter(filter);
            }
        });
        this.add(refilterButton);
        
        this.validate();
    }
    SpreadSheetPanel panel;
    Column column;
    JComponent value1;
    JComponent value2;
    JButton filterButton;
    JButton refilterButton;
}
