/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class EnzymeFrame extends JFrame {
    
    public EnzymeFrame(String xml) throws Exception {
        buildMenu();
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(new File(xml)); 
        Element ssElement = doc.getRootElement();
        //Create and set up the content pane.
        SpreadSheet config = new SpreadSheet(ssElement);
 //       spreadSheetPanel  = new SpreadSheetPanel(config);
        SpreadSheetModel model = spreadSheetPanel.getModel();
        model.loadAllFromDb();
        spreadSheetPanel.setOpaque(true); //content panes must be opaque
        this.setContentPane(spreadSheetPanel);

        //Display the window.
        this.pack();
        this.setSize(new Dimension(175,300));
    } 
    private void buildMenu(){
        JMenuBar menubar = new JMenuBar();
        
        JMenu fileMenu = new JMenu("File");
        JMenuItem saveItem = new JMenuItem("Save to DB");
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetModel model = EnzymeFrame.this.spreadSheetPanel.getModel();
                try {
                    model.updateDb();
                    model.setRowCount(0);
                    model.loadAllFromDb();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        
        fileMenu.add(saveItem);
        menubar.add(fileMenu);
        this.setJMenuBar(menubar);
    }
    public static void main(final String[] args) {    
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
                    EnzymeFrame frame = new EnzymeFrame("/net/waterston/vol2/home/gevirl/NetBeansProjects/Labmanagement/src/org/rhwlab/LMS/config/RestrictionEnzyme.xml");
                    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                    frame.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
    }
    SpreadSheetPanel spreadSheetPanel;
}
