/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.screen.ReporterAllele;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class CrossingPanel extends TrackingPanel {
    public CrossingPanel(){
        super(true,inits);
        buildMenu();
    }
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("Crossing");        
        
        JMenuItem toImage = new TransferMenuItem("To Imaging","Imaging",CrossingPanel.this);
        menu.add(toImage);
        
        JMenuItem toGen = new TransferMenuItem("To Generation","Generation",CrossingPanel.this);
        menu.add(toGen);
        
        JMenuItem toFreeze = new TransferMenuItem("To Freezing","Freeze",CrossingPanel.this);
        toFreeze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                
                StrainPanel panel = (StrainPanel)CrossingPanel.this.getConfig().getPanel("org.rhwlab.LMS.views.StrainPanel");
                if (panel == null) {
                    JOptionPane.showMessageDialog(LabMan.labMan,"Strain view is not loaded.\nStrain will not be updated if transfer completed." );
                    return;
                }
                int[] sel = CrossingPanel.this.getConvertedSelectedRows();
                SpreadSheetModel model = CrossingPanel.this.getModel();
                int col = model.findColumn("OffSpringStrain"); 
                int lineCol = model.findColumn("LineagingStrain");
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], col);
                    String strain = base.getValueAsString();

                    base = (CellBase)model.getValueAt(sel[i], lineCol);
                    String lineStrain = base.getValueAsString();
                    try {
                        String allele = ReporterAllele.valueFromStrain(lineStrain);
                        panel.appendLineagingLine(strain, allele);
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                }                
            }
        });
        menu.add(toFreeze);    
        
        JMenuItem toSelf = new TransferMenuItem("To Crossing","Self",CrossingPanel.this);
        menu.add(toSelf); 
    } 
    static String[] inits = {"Pending"};
}
