/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.AnalysisBy;
import org.rhwlab.LMS.RNASeq.AnalysisConditions;
import org.rhwlab.LMS.RNASeq.ExpressionID;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.dialogs.AddConditionDialog;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class AnalysisPanel extends TrackingPanel implements ActionListener {

    public AnalysisPanel() {
        super(false, inits);
        buildMenu();

    }

    public void buildMenu() {

        super.getMenu();
        menu.setText("Analysis");

        JMenuItem express = new JMenuItem(submitItem);
        express.addActionListener(this);
        menu.add(express);
        
        TransferMenuItem copyRecs = new TransferMenuItem("Copy Record(s)","Analysis",AnalysisPanel.this);
        menu.add(copyRecs);      
        
        JMenuItem fin = new JMenuItem(finish);
        fin.addActionListener(this);
//        menu.add(fin);        
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int[] rows = this.getConvertedSelectedRows();
            if (e.getActionCommand().equals(submitItem)) {
                for (int i = 0; i < rows.length; ++i) {
                    if (!canAnalyze(rows[i])) {
                        return;
                    }
                }
                int analysisColumn = this.getConfig().getColumn("AnalysisBy");
                for (int i = 0; i < rows.length; ++i) {
                    AnalysisBy analysis = (AnalysisBy) this.getModel().getValueAt(rows[i], analysisColumn);

                    analysis.submit();
                    this.updateDB();
                }

            } else if (e.getActionCommand().equals(finish)){
            for (int i=0 ; i<rows.length ; ++i){
                try {
                    Finisher finish = new Finisher(this.getValue(rows[i],"AnalysisID"),"Analysis");
                    finish.setDir(this.getValue(rows[i],"Directory"));
                    finish.init();
                    finish.run();
                } catch(Exception exc){
                    exc.printStackTrace();
                }
            }
        }
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private boolean canAnalyze(int row) throws Exception {
        if (this.getValue(row, "Directory").equals("")) {
            JOptionPane.showMessageDialog(this, "Enter a Directory\nNo cluster job was submitted");
            return false;
        }
        CellBase cell = (CellBase)this.getModel().getValueAt(row,this.getConfig().getColumn("Conditions"));
        AnalysisConditions conds = (AnalysisConditions)cell;
        for (String cond : conds.getConditionIDs()) {
            String[] replicates = conds.getReplicateIDs(cond);
            for (String replicate : replicates){
                if (!ExpressionID.expressionCompleted(replicate)){
                    JOptionPane.showMessageDialog(this, String.format("Expression calculation has not completed for replicate %s in %s\nNo cluster job submitted"
                    ,replicate,this.getValue(row,"AnalysisID")));
                    return false;                    
                }
            }
        }
        return true;
    }
    AddConditionDialog conditionDialog;
    static String submitItem = "Submit Analysis";
    static String finish = "Run finisher";
    static String[] inits = {"Pending"};

}
