/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class SplitFosmidDescr {
    static public void main(String[] args) throws Exception {
        PreparedStatement updateName = 
                MySql.getMySql().getStatement("Update Fosmid set FosmidName = ? where FosmidID = ?");
        PreparedStatement updateDescr = 
                MySql.getMySql().getStatement("Update Fosmid set FosmidDescr = ? where FosmidID = ?");        
        String sql = "select * from Fosmid";
        ResultSet rs = MySql.getMySql().execute(sql);
        while(rs.next()){
            String descr = rs.getString("FosmidDescr");
            String fosmidID = rs.getString("FosmidID");
            if (descr != null){
                descr = descr.trim();
                if (!descr.equals("")){
                    String fosmidName = descr;
                    int paren = descr.indexOf('(');
                    if (paren != -1){
                        fosmidName = descr.substring(0, paren);
                        descr = descr.substring(paren);
                    } else {
                        descr = "";
                    }
                    fosmidName = correctName(fosmidName);
                    System.out.printf("%s      %s\n", fosmidName,descr);
                    
                    updateName.setString(1, fosmidName);;
                    updateName.setString(2, fosmidID);
                    updateName.execute();
                    
                    updateDescr.setString(1, descr);
                    updateDescr.setString(2, fosmidID);
                    updateDescr.execute();
                    
                }
            }
        }
        
    }
    static private String correctName(String name){
        int index = name.indexOf('_');
        if (index == -1) return name;  
        
        String[] tokens = name.split("_");
        String prefix = tokens[0].substring(0,index-1);
        String suffix = name.substring(index+1);
        char upper = tokens[0].charAt(index-1);
        char lower = Character.toLowerCase(upper);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(lower);
        builder.append(suffix);
        String ret = builder.toString();
        return ret;
        
    }
}
