/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.rhwlab.LMS.DateCell;

/**
 *
 * @author gevirl
 */
public class PrepareRescue {
    public ArrayList<Rescue> loadRescues(String file,boolean latest) throws Exception {
        ArrayList<Rescue> ret = new ArrayList<Rescue>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        String[] heads = line.split("\t");

        line = reader.readLine();
        while(line!=null){
            String[] tokens = line.split("\t");

            HashMap<String,String> map = new HashMap<String,String>();
            for (int i=0 ; i<Math.min(heads.length,tokens.length) ;++i){
                map.put(heads[i], tokens[i]);
            }

            String location = map.get("Plate # (Fosmid) or Clone # (Plasmid)");
            String type = map.get("Construct Type (Fosmid or Plasmid)");
            String strain = map.get("unc-119 strain");
            
            String dateStr = map.get("Bomb Date");
            DateCell date = new DateCell();
            date.setValue(dateStr);
            Date stdDate = (Date)date.getValue();
            String gene = map.get("Gene");
            
            String plate = map.get("Rescue Clone #");

            

            
            Bomb bomb = null;
            if (type.toLowerCase().contains("fosmid")){
                bomb = new FosmidBomb(stdDate,gene,location,strain);
            } else if (type.toLowerCase().contains("plasmid")){
                bomb = new PlasmidBomb(stdDate,gene,location,strain);
            }
            if (bomb != null){
                bomb.loadFromDB();
                if (bomb.bombID != null){
                    if (latest){
                        Rescue latestRescue = new LatestRescue(bomb,plate,map);
                        ret.add(latestRescue);
                    } else {
                        Rescue eliciaRescue = new EliciaRescue(bomb,plate,map);
                        ret.add(eliciaRescue);
                    }
                }
            }
            line = reader.readLine();
        }
        reader.close();   
        return ret;
    }

    static public void main(String[] args) throws Exception   {
        PrepareRescue prepare = new PrepareRescue();
        ArrayList<Rescue> latest = prepare.loadRescues(args[0], true);
        ArrayList<Rescue> elicia = prepare.loadRescues(args[1], false);
        
        for (Rescue rescue : elicia){
            rescue.saveToDB();
 //           System.out.println(rescue.rescueID);
        }
        for (Rescue rescue : latest){
            rescue.saveToDB();
 //           System.out.println(rescue.rescueID);
        }        
        
    }
    
}
