/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.LMS.DateCell;

/**
 *
 * @author gevirl
 */
public class PrepareBombs {
    static public void main(String[] args)throws Exception {
        TreeSet<FosmidBomb> fosmidbombs = new TreeSet<FosmidBomb>();
        TreeSet<PlasmidBomb> plasmidbombs = new TreeSet<PlasmidBomb>();
        for (int f=0 ; f<args.length ; ++f){
            BufferedReader reader = new BufferedReader(new FileReader(args[f]));
            String line = reader.readLine();
            String[] heads = line.split("\t");

            HashMap<String,String> prepsByLocation = new HashMap<String,String>();
            
            line = reader.readLine();
            while(line!=null){
                String[] tokens = line.split("\t");

                HashMap<String,String> map = new HashMap<String,String>();
                for (int i=0 ; i<Math.min(heads.length,tokens.length) ;++i){
                    map.put(heads[i], tokens[i]);
                }

                String location = map.get("Plate # (Fosmid) or Clone # (Plasmid)");
                String type = map.get("Construct Type (Fosmid or Plasmid)");
                String dateStr = map.get("Bomb Date");
                String strain = map.get("unc-119 strain");
                DateCell date = new DateCell();
                date.setValue(dateStr);
                Date stdDate = (Date)date.getValue();
                
                String gene = map.get("Gene");
            if (gene.equals("C17E4.6")){
                int asdf=0;
            }                
                if (type.toLowerCase().contains("fosmid")){
                    fosmidbombs.add(new FosmidBomb(stdDate,gene,location,strain));
                } else if (type.toLowerCase().contains("plasmid")){
                    plasmidbombs.add(new PlasmidBomb(stdDate,gene,location,strain));
                }

                line = reader.readLine();
            }
            reader.close();
        }
          for (Bomb bomb : plasmidbombs){
            if (bomb.gene.equals("C17E4.6")){
                int asdf=0;
            }
        }
        
        PrintStream stream = new PrintStream("bombs.tab");
//        stream = System.out;
        for (FosmidBomb bomb : fosmidbombs){
            if (!bomb.findDNAPrep()){
                if (bomb.getFosmidID()==null){
//                    bomb.report(stream);  // fosmid bombs where a prep and the fosmid weren't found
                }
            }
        }
       
        for (PlasmidBomb bomb : plasmidbombs){
            if (!bomb.findDNAPrep() ){
 //               bomb.report(System.out);  // plasmid bombs where a prep couldn't be matched
            }
        }
         for (Bomb bomb : fosmidbombs){
            if (bomb.gene.equals("nhr-205")){
                int asdf=0;
            }
        }       
        ArrayList<Bomb> bombList = new ArrayList<Bomb>();
        ArrayList<FosmidBomb> needingPrep = new ArrayList<FosmidBomb>();
        for (FosmidBomb bomb : fosmidbombs){
            if (bomb.prepID != null){
               bombList.add(bomb);
               bomb.setByPrep(true);
            }else {
                if (bomb.fosmidID==null)
                    bomb.report(System.out);
                else {
                    // make a prep for this fosmid
                    needingPrep.add(bomb);
                    
                }
            }
        }
       
        PrintStream prepStream = new PrintStream("preps.tab");
        FosmidBomb.makePreps(needingPrep, prepStream);
        prepStream.close();
        
        for (PlasmidBomb bomb : plasmidbombs){
            if (bomb.prepID != null) {
                bombList.add(bomb);
                bomb.setByPrep(true);
            } else {
                bomb.report(System.out);
            }
        } 
        Bomb[] bombsArray = bombList.toArray(new Bomb[0]);
        Arrays.sort(bombsArray);
         
        Bomb.dump(bombsArray, stream);
        for (Bomb bomb : bombsArray){
 //           if (bomb.date.before(bomb.prepDate)&& bomb.construct.equals("Fosmid"))
 //               Bomb.dump(bomb,stream);
        }
//        PlasmidBomb.dump(plasmidbombs, stream);
//        FosmidBomb.dump(fosmidbombs, stream);
        stream.close();
    }
}
