/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.ResultSet;
import java.util.HashMap;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// back load the flosmid DNA preps 
public class FosmidPreps {
    static public void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        String[] heads = line.split("\t");
        
        line = reader.readLine();
        while(line!=null){
            String[] tokens = line.split("\t");
            
            HashMap<String,String> map = new HashMap<String,String>();
            for (int i=0 ; i<tokens.length;++i){
                map.put(heads[i], tokens[i]);
            } 
            String transgeneID = map.get("TransgeneID");
            String location = map.get("location");

            String plate = map.get("Plate");
            String fosmidID = null;
            if (transgeneID!=null && location!=null && !transgeneID.equals("") && !transgeneID.equals("empty")){
                if (location.equals("not verified, not sent")){
                    location ="";
                }                
                if (transgeneID.startsWith("p_wTRG5")||location.equals("")){
                    fosmidID = transgeneID;
                }else {
                    fosmidID = transgeneID+"_"+plate+location;
                }

                
                
                String prep = map.get("Fosmid Prep");
                if (prep!=null && !prep.equals("")){
                    String[] preps = prep.split(",");
                    String conc = map.get("DNA Concentration (ng/ul)");
                    if (conc!=null){
                
                // get the location from db
                String sql = String.format("Select * from Fosmid where FosmidID=\'%s\'",fosmidID);
                ResultSet rs = MySql.getMySql().execute(sql);
                rs.next();
                String loc = rs.getString("Plate")+rs.getString("Location");
                
                        String[] concs = conc.split(",");
                        int diff = preps.length - concs.length;
 //                       System.out.printf("%s\n", fosmidID);
                        for (int i=0 ; i<preps.length;++i){
                            // find the last prep no for this fosmid
                            sql = String.format("select max(PrepNumber) N from DNAPrep where DNAId=\'%s\' group by DNAId",fosmidID);
                            rs = MySql.getMySql().execute(sql);
                            int prepNo = 1;
                            if (rs.next()){
                                prepNo = rs.getInt("N")+1;
                            }                            
                            
                            DateCell cell = new DateCell();
                            cell.setValue(preps[i].trim());
                            if (cell.getValue()==null){
                                System.out.println(preps[i]);
                            }
                            int index = i-diff;
                            if (index >=0){
                                try {
                                    double c = Double.valueOf(concs[index]);
                                    sql = String.format("Insert into DNAPrep (DNAId,PrepNumber,PrepDate,Concentration,Location) values (\'%s\',%d,\'%s\',%f,\'%s\')",
                                            fosmidID,prepNo,cell.getAsSqlString(),c,loc);
                                    rs = MySql.getMySql().execute(sql);
                                    System.out.println(sql);
 //                                   System.out.printf("\t%s    conc:%s\n", preps[i],concs[index]);
                                }catch (Exception exc){
                                    if (!concs[index].equals(""))
                                        System.out.printf("%s    %s    conc:%s\n",fosmidID, preps[i],concs[index]);
                                }
                                
                            }
                            else {
 //                              System.out.printf("\t%s    No conc\n", preps[i]);
                                 sql = String.format("Insert into DNAPrep (DNAId,PrepNumber,PrepDate,Location) values (\'%s\',%d,\'%s\',\'%s\')",
                                            fosmidID,prepNo,cell.getAsSqlString(),loc);  
                                 System.out.println(sql);
                                 rs = MySql.getMySql().execute(sql);
                                 
                            }
                        }
                    }else {
                       System.out.printf("%s   %s    conc null\n", fosmidID,prep);
                    }
                }
            }
            line = reader.readLine();
        }
    } 
}
