/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BackFillFromPlasmidsDB {
    public static void main(String[] args)throws Exception {
        
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        String[] heads = line.split("\t");
        
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");

            HashMap<String,String> map = new HashMap<String,String>();
            for (int i=0 ; i<tokens.length;++i){
                map.put(heads[i], tokens[i]);
            }
            
            String plasmidName = map.get("Plasmid Name");

            String lPrimer = fixPrimer(map.get("Left Primer"));
            String rPrimer = fixPrimer(map.get("Right Primer"));
            
            // find the PrimerDesign that matches this PlasmidDB record
            String sql = String.format("Select * from PrimerDesign where PlasmidName=\'%s\' and LPrimer=\'%s\' and RPrimer=\'%s\'",plasmidName,lPrimer,rPrimer);
            ResultSet rs = MySql.getMySql().execute(sql);            
            if (rs.next()){
                String transcript = rs.getString("Transcript");

                String design = rs.getString("Design");
                
                // update the length in the PrimerDesign table\
/*                
                String length = map.get("Length");
                if (!length.equals("")){
                    try {
                        int l = Integer.parseInt(length);
                        sql = String.format("update PrimerDesign set SequenceLength=%s where Transcript=\'%s\' and Design=%s", length,transcript,design);
                        MySql.getMySql().execute(sql);
                    } catch (Exception exc){
                        System.out.printf("error parsing length %s\n",length);
                    }
                }
  
                 * 
                 */
                // find the plasmid record
                sql = String.format("select * from Plasmid where Transcript=\'%s\' and Design=%s",transcript,design);
                rs = MySql.getMySql().execute(sql);
                rs.next();
                String plasmidID = rs.getString("PlasmidID");
                StringBuilder notes = new StringBuilder();
                
                String NTI_MapFile = map.get("Vector NTI Map File");
                
                String NTI_Map = map.get("Vector NTI Map");
                Date mapDate = new Date();
                boolean mapStatus = parseDate(NTI_Map,mapDate);
                if (mapStatus){
                     NTI_Map= sqlFormat.format(mapDate);
                } else {
                    notes.append(NTI_Map);
                    notes.append("\n");
                }
                
                String NTI_File = map.get("Vector NTI File");
                Date fileDate = new Date();
                boolean fileStatus = parseDate(NTI_File,fileDate);
                if (fileStatus){
                     NTI_File= sqlFormat.format(fileDate);
                } else {
                    notes.append(NTI_File);
                    notes.append("\n");
                }                
                
                
                
                String pcr = map.get("PCR");
                Date pcrDate = new Date();
                boolean pcrStatus = parseDate(pcr,pcrDate);
                if (pcrStatus){
                    pcr = sqlFormat.format(pcrDate);
                } else {
                    notes.append(pcr);
                    notes.append("\n");
                }

                String cloned = map.get("Cloned");
                Date clonedDate = new Date();
                boolean clonedStatus = parseDate(cloned,clonedDate);
                if (clonedStatus){
                    cloned = sqlFormat.format(clonedDate);
                } else {
                    notes.append(cloned);
                    notes.append("\n");
                }

                String midi = map.get("Midi");
                Date midiDate = new Date();
                boolean midiStatus = parseDate(midi,midiDate);
                if (midiStatus){
                    midi = sqlFormat.format(midiDate);
                } else {
                    notes.append(midi);
                    notes.append("\n");
                }
                notes.append(map.get("Bombarded"));
                notes.append("\n");
                notes.append(map.get("Expression"));
                notes.append("\n");                
                notes.append(map.get("Status"));
                notes.append("\n");
                notes.append(map.get("Expression"));
                notes.append("\n");       
                notes.append(map.get("Milestone Completed"));
                notes.append("\n");
                notes.append(map.get("Status Notes"));
                notes.append("\n");  
                
                String noteStr = notes.toString();
                // update the plasmid record
                sql = String.format("Update Plasmid set Notes=\'%s\' where PlasmidID=\'%s\'",noteStr,plasmidID);
                MySql.getMySql().execute(sql);
                
                if (pcrStatus){
                    sql = String.format("Update Plasmid set PCRDate=\'%s\',PCRStatus=1 where PlasmidID=\'%s\'",pcr,plasmidID);
                    MySql.getMySql().execute(sql);                    
                }else {
                    sql = String.format("Update Plasmid set PCRStatus=0 where PlasmidID=\'%s\'",plasmidID);
                    MySql.getMySql().execute(sql);                   
                }
                if (pcrStatus){
                    sql = String.format("Update Plasmid set PCRDate=\'%s\',PCRStatus=1 where PlasmidID=\'%s\'",pcr,plasmidID);
                    MySql.getMySql().execute(sql);                    
                }else {
                    sql = String.format("Update Plasmid set PCRStatus=0 where PlasmidID=\'%s\'",plasmidID);
                    MySql.getMySql().execute(sql);                   
                }                
                if (clonedStatus){
                    sql = String.format("Update Plasmid set ClonedDate=\'%s\',ClonedStatus=1 where PlasmidID=\'%s\'",cloned,plasmidID);
                    MySql.getMySql().execute(sql);                    
                }else {
                    sql = String.format("Update Plasmid set ClonedStatus=0 where PlasmidID=\'%s\'",plasmidID);
                    MySql.getMySql().execute(sql);                   
                }  
                
                if (mapStatus){
                    sql = String.format("Update Plasmid set NTIMapDate=\'%s\' where PlasmidID=\'%s\'",NTI_Map,plasmidID);
                    MySql.getMySql().execute(sql);                    
                } 
                
                if (fileStatus){
                    sql = String.format("Update Plasmid set NTIFileDate=\'%s\' where PlasmidID=\'%s\'",NTI_File,plasmidID);
                    MySql.getMySql().execute(sql);                    
                }  
                    sql = String.format("Update Plasmid set NTIMapFile=\'%s\' where PlasmidID=\'%s\'",NTI_MapFile,plasmidID);
                    MySql.getMySql().execute(sql);                 
                if (clonedStatus){

/*                    
                    sql = String.format("select * from Clone C join GlycerolStock G on C.CloneId = G.Line where C.ConstructID='%s\' order by C.CloneNo",plasmidID);
                    ResultSet cloneRS = MySql.getMySql().execute(sql);
                    if (cloneRS.next()){
                        int box = cloneRS.getInt("G.Box");
                        String row = cloneRS.getString("G.BoxRow");
                        int col = cloneRS.getInt("G.BoxColumn");
                        String cloneID = cloneRS.getString("C.CloneId");
                        if (midiStatus){
                            sql = String.format("Select max(PrepNumber) max from DNAPrep where DNAId=\'%s\'",cloneID);
                            ResultSet prepRS = MySql.getMySql().execute(sql);
                            int prepNo = 1;
                            if (prepRS.next()){
                                prepNo = 1 + prepRS.getInt("max");
                            }
                            
                            System.out.printf("DNAPrep:  %s  %d  %s  %d%s%d\n",cloneID,prepNo,midi,box,row,col);
                            // add the dna prep
                            sql = String.format("Insert into DNAPrep (DNAId,PrepNumber,PrepDate,Box,BoxRow,BoxColumn) values (\'%s\',%d,\'%s\',%d,\'%s\',%d)"
                                    , cloneID,prepNo,midi,box,row,col);
                            MySql.getMySql().execute(sql);
                        }
                    } else {
  //                      System.out.printf("%s\n",plasmidID);
     //                   System.out.printf("%s(%s,%s)  (%s)\n",plasmidID,transcript,design,midi);
      //                  System.out.println("\t no glycerol stocks");
                    }
*/
                    if (pcrStatus && clonedStatus && midiStatus) {
  //                      System.out.printf("%s,%s,%s,%s,%s\n",plasmidName,length,pcr,cloned,midi);
                    }
                    else {
    //                    System.out.printf("%s,%s,%s\n",plasmidName,length,notes.toString());
                    }
                }else {
 //                   System.out.printf("Not cloned: %s    %s\n",plasmidName,cloned);
                }
            }
            line = reader.readLine();
        }
    }
    private static boolean parseDate(String str,Date date){
        if (str == null)return false;
        Date defaultDate=null;
        try {
            defaultDate = dateFormat.parse("1-Jan-08");
            Date parsed = dateFormat.parse(str);
            date.setTime(parsed.getTime()); 
            return true;
        } catch (ParseException exc){
            if (str.equalsIgnoreCase("yes")){
                date.setTime(defaultDate.getTime()); 
                return true;               
            }
        }
        return false;
    }
    static private String fixPrimer(String in){
        String lower = in.toLowerCase();
        if (lower.startsWith("tttt")){
            return lower.substring(10).trim();
        }
        return lower.trim();
    }     
    static SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
    static SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd");
}
