/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// args[0] csv file with fosmid descriptions
public class AddFosmidDescription {
    static public void main(String[] args) throws Exception {
        PreparedStatement select = 
                MySql.getMySql().getStatement("Select * from Fosmid F join Gene G on F.WBGene=G.WBGene where F.Received = ? and (F.Gene = ? or G.Sequence = ?)")       ;
        PreparedStatement updateName = 
                MySql.getMySql().getStatement("Update Fosmid set FosmidName = ? where FosmidID = ?");
        PreparedStatement updateDescr = 
                MySql.getMySql().getStatement("Update Fosmid set FosmidDescr = ? where FosmidID = ?");  
        HashMap<String,String> map = readCSVFile(new File(args[0]));
        
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(dateFormat.parse("2014-01-09").getTime());
        
        int count = 1;
        for(String gene : map.keySet()){
            String fosmidName="";
            String descr = map.get(gene);
            int paren = descr.indexOf('(');
            if (paren != -1){
                fosmidName = descr.substring(0, paren);
                descr = descr.substring(paren);
            } else {
                descr = "";
            }            
                descr = descr.trim();
                if (!descr.equals("")){
                    fosmidName = correctName(fosmidName);
                    select.setDate(1, date);
                    select.setString(2, gene);  
                    select.setString(3, gene); 
                    select.execute();
                    ResultSet rs = select.getResultSet();

                    
                    while(rs.next()){
                        String fosmidID = rs.getString("FosmidID");
                        System.out.printf("%d %s,%s:  %s      %s\n",count,fosmidID,gene,fosmidName,descr);
                        ++count;
                        
                        updateName.setString(1, fosmidName);
                        updateName.setString(2,fosmidID);
                        updateName.execute();

                        updateDescr.setString(1, descr);
                        updateDescr.setString(2,fosmidID);
                        updateDescr.execute();
                        
                    }
                    
                }
            }
        }
        
    
    static private HashMap<String,String> readCSVFile(File csv)throws Exception {
        HashMap<String,String> map = new HashMap<String,String>();
        BufferedReader reader = new BufferedReader(new FileReader(csv));
        String line = reader.readLine();
        String[] headers = line.split(",");
        int descCol=-1;
        int geneCol=-1;
        for (int i=0 ; i<headers.length ; ++i){
            if (headers[i].equals("Gene")){
                geneCol = i;
            }else if (headers[i].equals("Description")){
                descCol = i;
            }
        }
        
        line = reader.readLine();
        while (line != null){
            String tokens[] = line.split(",");
            String gene = tokens[geneCol];
            String rawDescr = tokens[descCol];
            map.put(gene, rawDescr);
            line = reader.readLine();
        }
        return map;
    }
    static private String correctName(String name){
        int index = name.indexOf('_');
        if (index == -1) return name;  
        
        String[] tokens = name.split("_");
        String prefix = tokens[0].substring(0,index-1);
        String suffix = name.substring(index+1);
        char upper = tokens[0].charAt(index-1);
        char lower = Character.toLowerCase(upper);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(lower);
        builder.append(suffix);
        String ret = builder.toString();
        return ret;
        
    }    
}
