/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.thaw;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.ThawModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ThawNo extends IntegerCell {
    public ThawNo(){
        this("");
    }
    public ThawNo(String id){
        super(id);
        inputs.put("StrainID",null);
    }    
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = inputs.get("StrainID");
        if (base != null){
            String strain = base.getValueAsString();

            // get the next design value
            ThawModel thawModel = (ThawModel)this.getModel();
            int n = 0;
            try {
                n = thawModel.nextThaw(strain,this.getRow());
            }catch(Exception exc){exc.printStackTrace();}

            this.setValue(Integer.toString(n));
            this.unlock();
            
        }
    }    
}
