/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.strain;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.bomb.BombID;
import org.rhwlab.LMS.rescue.RescueID;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Genotype extends TextCell {
    public Genotype(){
        this("");
    }
    public Genotype(String s){
        super(s);
        inputs.put("ConstructType",null);
        inputs.put("Construct",null);
        inputs.put("Gene",null);
        inputs.put("ConstructID",null);
        inputs.put("Rescue",null);
        inputs.put("RescueID",null);
        inputs.put("ReporterAllele", null);
    }
    public void stateChanged(ChangeEvent ce) {
        if (!this.getValueAsString().equals(""))return;
        String constructType = null;
        if (inputs.get("ConstructType")!=null){
            constructType = ((CellBase)inputs.get("ConstructType")).getValueAsString();
        }else {
            constructType = ((CellBase)inputs.get("Construct")).getValueAsString();
        }
        
        
        String gene = ((CellBase)inputs.get("Gene")).getValueAsString();
        RescueID rescueCell =((RescueID)inputs.get("Rescue"));
        if (rescueCell == null){
         rescueCell =((RescueID)inputs.get("RescueID"));   
        }
        String rescue = rescueCell.getValueAsString();
        ConstructID constructCell = ((ConstructID)inputs.get("ConstructID"));
        String constructID = constructCell.getValueAsString();
        String reporterAllele = ((CellBase)inputs.get("ReporterAllele")).getValueAsString();
        if (constructType.equals(""))return;
        if (rescue.equals(""))return;
        if (constructID.equals(""))return;
        if (reporterAllele.equals(""))return;
        
        StringBuilder build = new StringBuilder(reporterAllele);
        build.append("(");
        try {
            if (constructType.equals("Plasmid")){
                String transcript = constructCell.getTranscript();
                build.append(transcript);
                build.append("::H1-WCherry;unc-119(+))");
            } else {
                build.append(gene);
                build.append("::TY1 EGFP 3xFLAG(");
                build.append(constructID);
                build.append(");unc-119(+))");
            }
            String bombID = rescueCell.getBombID();
            String background = BombID.backgroundStrain(bombID);
            build.append(";unc-119 (");
            build.append(background);
            build.append(")");
            this.setValue(build.toString());
        } catch (Exception exc) {
            exc.printStackTrace();
        }
        
    }

}
