/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.scripts;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

/**
 *
 * @author gevirl
 */
// repairs the image location in the embryoDB xml and the Acetree xml
public class RepairEmbryoDB {
    public RepairEmbryoDB()throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        
        File directory = new File("/nfs/waterston/embryoDB");
        File[] xmls = directory.listFiles(new FilenameFilter(){
            public boolean accept(File dir,String name){
                if (name.endsWith(".xml")) {
                    return true;
                }
                return false;
            }
        });
        
        for (File embryoDBxml : xmls){
            // parse the embryoDB xml file
            embryoDBDocument = saxBuilder.build(embryoDBxml); 
            Element rootElement = embryoDBDocument.getRootElement();
            imagelocElement = rootElement.getChild("imageloc");
            imageloc = imagelocElement.getAttributeValue("loc");
            String locSave = imageloc;
            if (imageloc.startsWith("/net/waterston/vol1")){
                imageloc = imageloc.replace("vol1", "vol9");
            } else if (imageloc.startsWith("/net/waterston/vol2")){
                imageloc = imageloc.replace("vol2", "vol9");
            } else if (imageloc.startsWith("/nfs/waterston1")){
                imageloc = imageloc.replace("/nfs/waterston1","/net/waterston/vol9");
            } else if (imageloc.startsWith("/nfs/waterston2")){
                imageloc = imageloc.replace("/nfs/waterston2", "/net/waterston/vol9");
            } else {
                continue;
            }
            if (!imageloc.equals(locSave)){
                System.out.printf("%s----%s\n",locSave,imageloc);
                imagelocElement.setAttribute("loc", imageloc);
                XMLOutputter outputter = new XMLOutputter();
                try {
                PrintStream outStream = new PrintStream(embryoDBxml);
                outputter.output(this.embryoDBDocument,outStream);  
                outStream.close();
                } catch (Exception exc){
                    System.out.printf("Cannot change %s\n",embryoDBxml.getName());
                }
                int ajsdf=0;
            }

 /*           
            Element annotsElement = rootElement.getChild("annots");
            annotsloc = annotsElement.getAttributeValue("loc");

            Element acetreeElement = rootElement.getChild("acetree");
            acetreeConfig = acetreeElement.getAttributeValue("config");

            try {
            acetreexml = new File(annotsloc+"/dats/"+acetreeConfig); 
            acetreeDocument = saxBuilder.build(acetreexml);
            } catch (Exception exc){
                System.out.printf("%s   %s\n",annotsloc,acetreeConfig);
            }
         * */        
        } 

    }
    
    
    static public void main(String[] args)    throws Exception {
        RepairEmbryoDB repair = new RepairEmbryoDB();
        

    }
    File acetreexml;
    Document embryoDBDocument;
    Document acetreeDocument;
    Element imagelocElement;
    String imageloc;
    String annotsloc;
    String acetreeConfig;     
}
