/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.scripts;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
// from a file of strains finds determine if there is a like strain in db
public class MissingStrains {
    static public void main(String[] args )throws Exception{
        PreparedStatement byID = MySql.getMySql().getStatement("Select * from Strain where StrainID = ?");
        PreparedStatement byGene = MySql.getMySql().getStatement("Select * from Strain where Gene = ? and ConstructType = ?");
        PreparedStatement tf = MySql.getMySql().getStatement("Select * from TFs where Gene = ?");
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        String line = reader.readLine();
        String[] headers = line.split("\t");
        int strainCol = -1;
        int geneCol = -1;
        for (int i=0 ; i<headers.length;++i){
            if (headers[i].equals("StrainID")){
                strainCol = i;
            }
            else if (headers[i].equals("Gene")){
                geneCol = i;
            }
        }
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            byID.setString(1, tokens[strainCol]);
            byID.execute();
            ResultSet rs = byID.getResultSet();
            if (!rs.next()){
                // not found in Strain
                byGene.setString(1, tokens[geneCol]);
                byGene.setString(2, args[1]);
                byGene.execute();
                ResultSet rsGene = byGene.getResultSet();
                if (!rsGene.next()){
                    // gene also not found
                    tf.setString(1, tokens[geneCol]);
                    tf.execute();
                    ResultSet rsTF = tf.getResultSet();
                    if (rsTF.next()){
                        System.out.println(line);
                    }
                }
            }
            line = reader.readLine();
        }
    }
}
