/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.screen;

import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.BooleanCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.models.ScreenModel;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Strain extends TextCell {
    public Strain(){
        this("");
    }
    public Strain(String s){
        super(s);
        inputs.put("Construct", null);
    }
    public void stateChanged(ChangeEvent ce) {
        

        Object source = ce.getSource();
        if (source instanceof BooleanCell){
            BooleanCell cell = (BooleanCell)source;
            String type = ((CellBase)inputs.get("Construct")).getValueAsString();
            ScreenModel model =(ScreenModel)this.getModel();
            if (cell.getValueAsString().equals("1")){
                if (this.getValueAsString().equals("")){
                    String next;
                    try {
                    if (type.equals("Plasmid")||type.equals("CRISPR")){
                        next = model.nextRWStrain();
                    } else {
                        next = model.nextOPStrain();
                    }
                    this.setValue(next);
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                }
            } else {
                String current = this.getValueAsString();
                if (type.equals("Plasmid")){
                    if (current.startsWith("RW")){
                        model.returnRWStrain(current);
                        this.setValue("");
                    }
                } else if (current.startsWith("OP")){
                    model.returnOPStrain(current);
                    this.setValue("");
                }                
                
            }
        }
 
    } 
    public String getConstructID()throws Exception {
        String sql = String.format("Select * from Strain where StrainID=\'%s\'",this.getValueAsString());
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("ConstructID");
        } else{
            return "";
        }
    }
}
