/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.sci;

import java.io.File;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.RNASeq.AlignReference;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class AlignmentID extends TextCell implements GridSubmittable{
    public AlignmentID(){
        super();
        inputs.put("Reference",null);
        inputs.put("SequencingID",null);
        inputs.put("Count",null);
        inputs.put("AlignDirectory",null);
        inputs.put("UMIattachDirectory",null);
        inputs.put("TrimDirectory",null);
        inputs.put("STAR_Directory",null);
        inputs.put("FilterSortDirectory",null);
        inputs.put("TrimSubmitted",null);
        inputs.put("TrimCompleted",null);
        inputs.put("AlignSubmitted",null);
        inputs.put("AlignCompleted",null);   
        inputs.put("FilterSortSubmitted",null);
        inputs.put("FilterSortCompleted",null);        
    }    

    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        
        String alignDir = inputs.get("AlignDirectory").getValueAsString();
        File alignDirFile = new File(alignDir);
        String alignID = this.getValueAsString();
        
        ProcessBuilder pb = new ProcessBuilder("mkdir","-p",alignDir);
        Process p = pb.start();
        p.waitFor();
        
        GridSubmit gs = new GridSubmit(alignID,program,alignDirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();  
        
        if (program.equals("TrimPolyA")){
            inputs.get("TrimSubmitted").setValue(new Date());  
            inputs.get("TrimCompleted").setValue(null);            
            qsubStream.println("module load python/2.7.3");
            qsubStream.println("module load cutadapt/1.8.3");
            qsubStream.println("module load trim_galore/0.4.1");
            qsubStream.println("module load parallel/latest");
            String trimDir = inputs.get("TrimDirectory").getValueAsString();
            qsubStream.printf("mkdir -p %s\n", trimDir);
            String umiDir = inputs.get("UMIattachDirectory").getValueAsString();
            qsubStream.printf("for F in `ls -1 %s` \n",umiDir);
            qsubStream.println("do");
            qsubStream.printf("trim_galore %s/$F -a AAAAAAAA --three_prime_clip_R1 1 -o %s \n",
                    umiDir,trimDir);
            qsubStream.println("done");
           
        }else if (program.equals("Align")){
            inputs.get("AlignSubmitted").setValue(new Date());  
            inputs.get("AlignCompleted").setValue(null);            
            AlignReference alignRef = (AlignReference)inputs.get("Reference");
            String inputDirStr = inputs.get("UMIattachDirectory").getValueAsString();
            if (!inputs.get("TrimCompleted").getValueAsString().equals("")){
                inputDirStr = inputs.get("TrimDirectory").getValueAsString();
            }
            String starDir = inputs.get("STAR_Directory").getValueAsString();
            pb = new ProcessBuilder("mkdir","-p",starDir);
            p = pb.start();
            p.waitFor();             
            // get a list of fastqs to align
            File inputDir = new File(inputDirStr);
            File[] files = inputDir.listFiles();
            for (File file : files){
                String sample = file.getName().substring(0, 6);
                qsubStream.printf("%s ", alignRef.getProgram());
                qsubStream.printf("--runThreadN %d ",cores);
                qsubStream.printf("--outSAMstrandField intronMotif ");
                qsubStream.printf("--readFilesCommand zcat ");
                qsubStream.printf("--genomeLoad LoadAndKeep ");
                qsubStream.printf("--genomeDir %s ",alignRef.getGenomicIndex());
                qsubStream.printf("--readFilesIn %s ",file.getPath());
                qsubStream.printf("--outFileNamePrefix %s/%s\n",starDir,sample);
            }
        } else if (program.equals("FilterSort")){
            inputs.get("FilterSortSubmitted").setValue(new Date());  
            inputs.get("FilterSortCompleted").setValue(null);  
            
            String filterDir = inputs.get("FilterSortDirectory").getValueAsString();
            pb = new ProcessBuilder("mkdir","-p",filterDir);
            p = pb.start();
            p.waitFor(); 
            qsubStream.println("module load samtools/latest");
            File starDir = new File(inputs.get("STAR_Directory").getValueAsString());
            File[] files = starDir.listFiles();
            for (File file : files){
                if (file.getName().endsWith("sam")){
                    String sample = file.getName().substring(0, 6);
//                    qsubStream.printf("samtools view -bh -q 30 -F 4 %s|samtools sort -@ %d -|samtools view -h ->%s/%s.sam\n",
                    qsubStream.printf("samtools view -bh -q 30 -F 4 %s|samtools sort -@ %d - > %s/%s.bam\n",
                            file.getPath(),cores,filterDir,sample);
                }
            }
        }
        ArrayList<String> args = new ArrayList<>();
        args.add(program);
        args.add(alignID);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.sci.AlignmentID", args);        
        gs.run();
    }
    public void stateChanged(ChangeEvent event){
        String count = inputs.get("Count").getValueAsString();
        if (count.equals(""))return;
        String seqID = inputs.get("SequencingID").getValueAsString();
        if (seqID.equals("")) return;
        this.setValue(String.format("%s_%s",seqID,count));
    } 
    static public void main(String[] args)throws Exception{
        if (args[0].equals("TrimPolyA")){
            PreparedStatement state = MySql.getMySql().getStatement("update sciAlignment set TrimCompleted = ? where AlignmentID = ?");
            state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
            state.setString(2, args[1]);
            state.execute();   
        }
        else if (args[0].equals("Align")){
            PreparedStatement state = MySql.getMySql().getStatement("update sciAlignment set AlignCompleted = ? where AlignmentID = ?");
            state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
            state.setString(2, args[1]);
            state.execute();   
        }    
        else if (args[0].equals("FilterSort")){
            PreparedStatement state = MySql.getMySql().getStatement("update sciAlignment set FilterCompleted = ? where AlignmentID = ?");
            state.setTimestamp(1, new Timestamp(new java.util.Date().getTime()));
            state.setString(2, args[1]);
            state.execute();   
        }         
    }
}
