/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.rescue;

import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.screen.Strain;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class RescueID extends TextCell {
    public RescueID(){
        this("");
    }
    public RescueID(String id){
        super(id);
        inputs.put("BombID", null);
        inputs.put("Plate", null);
    }
    
    public void stateChanged(ChangeEvent ce) {
        Object source = ce.getSource();
        if (source instanceof Strain){
            Strain strainCell = (Strain)source;
            if (this.getValueAsString().equals("")){
                String sql = String.format("Select Rescue from Strain where StrainID=\'%s\'",strainCell.getValueAsString());
                try {
                    ResultSet rs = MySql.getMySql().execute(sql);
                    if (rs.next()){
                        this.setValue(rs.getString("Rescue"));
                    }
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
            return;
        }
        CellBase base = inputs.get("BombID");
        if (base != null){
            String dnaPrep = base.getValueAsString();
                base = inputs.get("Plate");
                if (base != null){
                    String plateNo = base.getValueAsString();
                    this.setValue(dnaPrep + "_" + plateNo);
                }
        }
    }
    public String getGeneName() throws Exception {
        String prepID = removeSuffix(removeSuffix(this.getValueAsString()));
        String sql = String.format("select Gene from DNAPrep where PrepID=\'%s\'",prepID);
        ResultSet rs = MySql.getMySql().execute(sql);
        rs.next();
        return rs.getString("Gene");
    }
    public String getConstructType() throws Exception {
        if (this.getValueAsString().startsWith("CRISPR")){
            return "CRISPR";
        }        
        String prepID = removeSuffix(removeSuffix(this.getValueAsString()));
        String sql = String.format("select ConstructType from DNAPrep where PrepID=\'%s\'",prepID);
        ResultSet rs = MySql.getMySql().execute(sql);
        rs.next();
        return rs.getString("ConstructType");        
    }
    public String getReporterConstruct() throws Exception {
        if (this.getValueAsString().equals("")) return null;
        if (this.getValueAsString().startsWith("CRISPR")){
            String rescueID = this.getValueAsString();
            String injectionID = rescueID.substring(0,rescueID.lastIndexOf("_"));
            return injectionID.substring(0, injectionID.lastIndexOf("_"));
        }
        
        if (this.getValueAsString().contains("dsHybrid")){
            String[] tokens = this.getValueAsString().split("_");
            return String.format("%s_%s_%s_%s",tokens[0],tokens[1],tokens[2],tokens[3]);
        }
        String prepID = removeSuffix(removeSuffix(this.getValueAsString()));
        String sql = String.format("select * from DNAPrep where PrepID=\'%s\'",prepID);
        ResultSet rs = MySql.getMySql().execute(sql);
        rs.next(); 
        
        String constructType = rs.getString("ConstructType");
        String dnaID = rs.getString("DNAId");
        String ret = null;
        if (constructType.equals("Fosmid")){
            ret = dnaID;
        }else {
            sql = String.format("Select ConstructID from Clone where CloneID=\'%s\'",dnaID);
            rs = MySql.getMySql().execute(sql);
            rs.next(); 
            ret = rs.getString("ConstructID");
        }
        
        return ret;
    }
    public String getBombID(){
        return removeSuffix(this.getValueAsString());
    }
}
