/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.report;

import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class FosmidSummaryPanel extends JPanel{
    public FosmidSummaryPanel()throws Exception {
        super();
        DefaultTableModel model = new DefaultTableModel();
        JTable table = new JTable(model);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
        
        for (int i=0 ; i<columnHeadings.length;++i){
            model.addColumn(columnHeadings[i]);
        }
        
        for (int i=0 ; i<rowLabels.length ; ++i){
            Vector row = new Vector();
            row.add(rowLabels[i]);
            for (int j=1 ; j<columnHeadings.length ; ++j){
                ResultSet rs = MySql.getMySql().execute(sql[j-1]);
                if (rs.next()){
                    int count = rs.getInt("Count");
                    row.add(new Integer(count));
                }
            }
            model.addRow(row);
        }
        
    }
    static String[] columnHeadings = {"Fosmid","Strains","Genes","TFs","NHRs"};
    static String[] rowLabels = {"Total"};
    static String[] sql = {
        "select count(distinct StrainID) Count from Strain where ConstructType='Fosmid'",
        "select count(distinct Strain.Gene) Count from Strain join Fosmid on Strain.ConstructID=Fosmid.FosmidID where Strain.ConstructType='Fosmid'",
        "select count(distinct TFs.Gene) Count from "
            + "(select distinct Strain.Gene from Strain join Fosmid on Strain.ConstructID=Fosmid.FosmidID where Strain.ConstructType='Fosmid') "
            + "J join TFs on TFs.Gene=J.Gene",
        "select count(distinct T.Gene) Count from "
            + "(select distinct Strain.Gene from Strain join Fosmid on Strain.ConstructID=Fosmid.FosmidID where Strain.ConstructType='Fosmid') "
            + "J join (select * from TFs where Gene like 'nhr%' ) T on T.Gene=J.Gene"            
    };
}
