/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.prep;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.DNAPrepModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class PrepNumber extends IntegerCell {
    public PrepNumber(){
        this("");
    }
    public PrepNumber(String id){
        super(id);
        inputs.put("DNA ID",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = inputs.get("DNA ID");
        String dnaID = base.getValueAsString();
        
        // get the next design value
        DNAPrepModel prepModel = (DNAPrepModel)this.getModel();
        int n = 0;
        try {
            n = prepModel.nextPrep(dnaID,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(n));
        this.unlock();
    }    
}
