/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.plasmid;

import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class PlasmidID extends TextCell {
    public PlasmidID(){
        this.inputs.put("Transcript",null);
        this.inputs.put("Design",null);
        this.inputs.put("Vector",null);
    }
    public void stateChanged(ChangeEvent ce) {
        String transcript = inputs.get("Transcript").getValueAsString();
        if (transcript.equals("")) return;
        String design = inputs.get("Design").getValueAsString(); 
        if (design.equals("")) return;
        String vector = inputs.get("Vector").getValueAsString();
        if (vector.equals("")) return;
            StringBuilder builder = new StringBuilder();
            builder.append(vector);
            builder.append("::");
            builder.append(transcript);
            builder.append("_");
            builder.append(design);
            String newValue = builder.toString();
            if (validate(newValue))
                this.setValue(newValue);
            else {
                JOptionPane.showMessageDialog(LabMan.labMan, "Duplicate Plasmid ID");
                this.setValue("");
            }
    }
    @Override
    public boolean validate(String newValue) {
        return true;
/*        
        if (!validate) return true;
        // check that the newValue is not already present in the table
        SpreadSheetModel m = (SpreadSheetModel)this.getModel();
        return !m.isPresent(newValue, this.getColumn());
*/
    }    
}
