/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.path;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.Project;
import org.rhwlab.spreadsheet.Tracking;

/**
 *
 * @author gevirl
 */
public class PathStatusFrame extends JFrame {
    public PathStatusFrame()throws Exception {
        dialog = new DisplayPathDialog();
        dialog.setSize(300,300);
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BoxLayout(eastPanel,BoxLayout.Y_AXIS)); 
        
        eastPanel.add(new JLabel("Project"));
        projectList = new JList(Project.makeBox().getModel());
        JScrollPane projectScroll = new JScrollPane(projectList);
        eastPanel.add(projectScroll);
        
        eastPanel.add(Box.createVerticalStrut(20));
        eastPanel.add(new JLabel("Path"));
        DefaultListModel pathListModel = new DefaultListModel();
        String sql = "Select * from LMSPath order by Name";
        this.pathMap = new TreeMap<>();
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String name = rs.getString("Name");
            pathListModel.addElement(name);
            pathMap.put(name, new LMSPath(rs.getString("StartTable"),rs.getString("StartColumn"),rs.getString("DisplayColumn")));
        }
        pathList = new JList(pathListModel);
        JScrollPane pathScroll = new JScrollPane(pathList);
        eastPanel.add(pathScroll);
        
        JButton submit = new JButton("Submit");
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    doSummary();
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        JButton displayButton = new JButton("Display Path(s)");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        displayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedPaths = pathList.getSelectedValuesList();
                try {
                    dialog.DisplayPaths((String[])selectedPaths.toArray(new String[0]));
                    dialog.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
                
            }
        });
        JButton rebuild = new JButton("RefreshAll");
        rebuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PathStatusTable.rebuildAll();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        buttonPanel.add(submit);
        buttonPanel.add(displayButton);
        buttonPanel.add(rebuild);
        eastPanel.add(buttonPanel);
        
        centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel,BoxLayout.Y_AXIS));
        JScrollPane scroll = new JScrollPane(centerPanel);
        
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add(eastPanel,BorderLayout.EAST);
        content.add(scroll,BorderLayout.CENTER);
        this.add(content);
        this.pack();        
    }
    private void doSummary()throws Exception {
        centerPanel.removeAll();
        String[] tracking = Tracking.getTrackingValues();
        PreparedStatement state = MySql.getMySql().getStatement("Select * from LMSSummary where Project=? and Path=? and RootKey=? order by Status,PathOrder desc");
        List selectedProjects = projectList.getSelectedValuesList();
        List selectedPaths = pathList.getSelectedValuesList();
        
        for (Object projectObj : selectedProjects){
            String project = (String)projectObj;
            for (Object pathObj : selectedPaths){
                
                DefaultTableModel model = new DefaultTableModel();
                model.addColumn("PathBeginsAt");
                model.addColumn("Alias");
                model.addColumn("RootStatus");
                model.addColumn("DeepestTable");
                for (String track : tracking){
                    model.addColumn(track);
                }
                
                
                String path = (String)pathObj;
                Map rootStatusMap = buildRootStatusMap(path,project);
                
                String sql = String.format("select distinct RootKey from LMSSummary L where Project=\'%s\' and Path=\'%s\' ",project,path);
                ResultSet rs = MySql.getMySql().execute(sql);
                while(rs.next()){
                    String deepestTable = null;
                    int deepestLevel = 0;
                    String key = rs.getString("RootKey");
                    state.setString(1, project);
                    state.setString(2, path);
                    state.setString(3, key);
                    ResultSet keyRS = state.executeQuery();
                    
                    TreeMap<String,PathStatus> statusMap = new TreeMap<>();

                    String previousStatus = null;
                    PathStatus pathStatus = null;
                    while (keyRS.next()){
                        String table = keyRS.getString("DBTable");
                        String status = keyRS.getString("Status");
                        int level = keyRS.getInt("PathOrder");
                        if (level > deepestLevel){
                            deepestLevel = level;
                            deepestTable = table;
                        }

                        if (previousStatus==null || !status.equals(previousStatus)){
                            pathStatus = new PathStatus(status,table);
                            previousStatus = status;
                            statusMap.put(status, pathStatus);
                        } 
                        if (table.equals(pathStatus.getTable())){
                            String reason = keyRS.getString("Reason");
                            String id = keyRS.getString("DataKey");
                            if (reason==null) reason ="";
                            statusMap.get(status).addReason(String.format("%s: %s",id,reason));                                
                        }

                    }                        

                    Object[] row = new Object[tracking.length+N];
                    row[0] = key;
                    row[1] = getAlias(path,key);
                    row[2] = rootStatusMap.get(key);
                    row[3] = deepestTable;
                    for (int i=N ; i<row.length ; ++i){
                        row[i] = statusMap.get(tracking[i-N]);
                    }
                    model.addRow(row);
                    
                    
                }
                StatusSummaryPanel summaryPanel = new StatusSummaryPanel(path,project,model);
                JTable jtable = summaryPanel.getTable();
                int n = jtable.getColumnCount();
                for (int i=N ; i<n ; ++i){
                    TableColumn column = jtable.getColumnModel().getColumn(i);
                    column.setCellEditor(new ReasonsDisplay());
                }                
                centerPanel.add(summaryPanel);
                centerPanel.add(Box.createVerticalStrut(30));
            }
        }
        this.validate();
        this.repaint();
    }
    private Map buildRootStatusMap(String path,String project)throws Exception {
        TreeMap<String,String> ret  = new TreeMap<>();
        String sql = String.format("select RootKey,Status from LMSSummary where PathOrder=1 and Project=\'%s\' and Path=\'%s\'", project,path);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String rootKey = rs.getString("RootKey");
            ret.put(rootKey, rs.getString("Status"));
        }
        return ret;
    }
    private String getAlias(String path,String key)throws Exception {
        LMSPath lmsPath = pathMap.get(path);
        String sql = String.format("Select %s from %s where %s = \'%s\'",lmsPath.aliasCol,lmsPath.table,lmsPath.keyCol,key);
        ResultSet rs = MySql.getMySql().execute(sql);
        rs.next();
        return rs.getString(lmsPath.aliasCol);
    }

    static public void main(String[] args){
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                PathStatusFrame frame = new PathStatusFrame();
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                frame.setSize(800, 500);
                frame.setTitle("Path Tracking Report");
                frame.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
    }
    static public int N=4; // number of columns before status data
    JList projectList;
    JList pathList;
    JPanel centerPanel;
    DisplayPathDialog dialog;
    Map<String,LMSPath> pathMap;
    
    class LMSPath{
        public LMSPath(String table,String keyCol,String aliasCol){
            this.table = table;
            this.keyCol = keyCol;
            this.aliasCol = aliasCol;
        }
        String table;
        String keyCol;
        String aliasCol;
    }

}
