/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.onset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.rhwlab.beans.ExpOnsetsEmbryo;
import org.rhwlab.views.onsetmodel.EmbryoPanel;
import org.rhwlab.expression.ExpressionOnset;

/**
 *
 * @author gevirl
 */
public class OnsetsEditor extends AbstractCellEditor implements TableCellEditor{
    public OnsetsEditor()throws Exception {
        button = new JButton();
        dialog = new OnsetsEditor.OnsetsDialog();
        dialog.setSize(new Dimension(500,300));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                    ExpOnsetsEmbryo embryo = null;
                    try {
                        embryo = cellObj.getEmbryo();

                    HashMap<String,ExpressionOnset> map = cellObj.getMap();
                    embryo.setExpressionOnsets(map);
                    Dimension dim = new Dimension(500,200);
                    Dimension diml = new Dimension(500,10000);
                    if (embryoPanel != null){
                        dialog.mainPanel.remove(embryoPanel);
                    }
                    embryoPanel = new EmbryoPanel(embryo,map,dim,diml);
                    dialog.mainPanel.add(embryoPanel,BorderLayout.CENTER); 
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }                    
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });        
    }
    public Object getCellEditorValue(){

        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (Onsets)value;
        String cellString = (String)cellObj.getValue();
        button.setText(cellString);

        return button;
    } 
     public boolean stopCellEditing() {

        return super.stopCellEditing();
     }    
    class OnsetsDialog extends JDialog{
        public OnsetsDialog()throws Exception {
            Container content = this.getContentPane();
            mainPanel = new JPanel(new BorderLayout());
            

            
            JPanel buttonPanel = new JPanel();
            JButton accept = new JButton("Accept changes");
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    accepted = true;
                    cellObj.setMapfromEmbryo();
                    cellObj.cellHasBeenChanged();
                    OnsetsEditor.OnsetsDialog.this.setVisible(false);
                }
            });
            
            buttonPanel.add(accept);
            JButton reject = new JButton("Discard changes");
            reject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OnsetsEditor.OnsetsDialog.this.setVisible(false);
                }
            });
            
            buttonPanel.add(reject);
            mainPanel.add(buttonPanel,BorderLayout.SOUTH);
            content.add(mainPanel);
        }

        public boolean isAccepted(){
            return accepted;
        }
        boolean accepted;
        JPanel mainPanel;
    }
  
    
    OnsetsEditor.OnsetsDialog dialog;
    EmbryoPanel embryoPanel=null;
    Onsets cellObj;  
    JButton button;
}
