/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.TreeSet;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.LMS.rescue.RescueID;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class ScreenModel extends SpreadSheetModel {
    public ScreenModel() {
    }

    private TreeSet<Integer> availableIDs(String sql,int[] starts,int[] ends)throws Exception {
        
        TreeSet<Integer> used = new TreeSet<Integer>();
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            int id  = rs.getInt("id");
            used.add(id);
        }
        TreeSet<Integer> avail = new TreeSet<Integer>(); 
            for (int i=0 ; i<starts.length ; ++i){
            for (int id=starts[i] ; id <= ends[i] ; ++id){
                if (!used.contains(id)){
                    avail.add(id);
                }
            }
        }
        return avail;
    }

    public String nextRWStrain()throws Exception {
        if (rwAvail == null){
            String sql = "Select cast(substr(StrainID,3) as unsigned) id from Strain where StrainID like \'RW%\' and StrainID < \'RW20000\'" ;
            rwAvail = availableIDs(sql,rwStarts,rwEnds);            
        }
        int next = rwAvail.first();
        rwAvail.remove(next);
        return String.format("RW%d",next);
    }
    public String nextOPStrain()throws Exception {
        if (opAvail == null){
            String sql = "Select cast(substr(StrainID,3) as unsigned) id from Strain where StrainID like \'OP%\'" ;
            opAvail = availableIDs(sql,opStarts,opEnds);            
        }
        int next = opAvail.first();
        opAvail.remove(next);
        return String.format("OP%d",next);
    } 
    public void returnRWStrain(String rw){
        int id = Integer.valueOf(rw.substring(2));
        rwAvail.add(id);
    }
    public void returnOPStrain(String op){
        int id = Integer.valueOf(op.substring(2));
        opAvail.add(id);
    }    
    public void archive(int[] rows) throws Exception   {
        PreparedStatement state = MySql.getMySql().getStatement("Update Screening set Archived = 1 where RescueID = ? and Received = ?");
        int rescueCol = this.findColumn("RescueID");
        int receivedCol = this.findColumn("Received");
        for (int row : rows){
            RescueID rescueID  = (RescueID)this.getValueAt(row, rescueCol);
            DateCell received = (DateCell)this.getValueAt(row, receivedCol);
            state.setString(1, rescueID.getValueAsString());
            state.setString(2, received.getAsSqlString());
            state.execute();
        }
    } 
    int[] opStarts = { 75,300,501,603};
    int[] opEnds =   {124,499,599,1000};
    
    int[] rwStarts = {11800};
    int[] rwEnds = {19999};
    
    TreeSet<Integer> opAvail=null;
    TreeSet<Integer> rwAvail=null;    
}
