/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class PrimerDesign extends SpreadSheetModel{
    public PrimerDesign()throws Exception {
        super();
    }
    // determine the next available design id for the given transcript
    public int nextDesign(String transcript,int row) throws Exception {
        // get the largest id from the database
        String sql = String.format("Select max(Design) max from PrimerDesign where Transcript=\'%s\'",
                transcript);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records for the transcript;
        
        // also look at the transcripts in the spreadsheet in case the have been additions
        int transcriptColumn = this.getConfig().getColumn("Transcript");
        int designColumn = this.getConfig().getColumn("Design");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,transcriptColumn);
            String cellTrans = base.getValueAsString();
            if (cellTrans.equals("") || !cellTrans.equals(transcript)) continue;
            String cellDesign = ((CellBase)this.getValueAt(r,designColumn)).getValueAsString();
            if (cellDesign.equals(""))continue;
            int designValue = Integer.valueOf(cellDesign);
            if (max < designValue) max = designValue;
        }
        return max+1;
    }
}

