/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class FreezeModel extends SpreadSheetModel {
    // determine the next available freezeno for the given strain
    public int nextFreeze(String strain,int row) throws Exception {
        // get the largest id from the database
        String sql = String.format("Select max(FreezeNo) max from Freezing where StrainID=\'%s\'",strain);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records for the transcript;
        
        // also look at the transcripts in the spreadsheet in case the have been additions
        int strainColumn = this.getConfig().getColumn("StrainID");
        int freezeNoColumn = this.getConfig().getColumn("FreezeNo");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,strainColumn);
            String cellTrans = base.getValueAsString();
            if (cellTrans.equals("") || !cellTrans.equals(strain)) continue;
            
            String cellDesign = ((CellBase)this.getValueAt(r,freezeNoColumn)).getValueAsString();
            if (cellDesign.equals(""))continue;
            int designValue = Integer.valueOf(cellDesign);
            if (max < designValue) max = designValue;
        }
        return max+1;
    }    
}
