/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.models;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;

/**
 *
 * @author gevirl
 */
public class FlyMiSeqModel extends SpreadSheetModel  {
    public int nextCount(String cDNA,int row) throws Exception {
        // get the largest id from the database
        String sql = String.format("Select max(cDNACount) max from Miseq where cDNAID=\'%s\' ",cDNA);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records for the transcript;
        
        // also look at the transcripts in the spreadsheet in case the have been additions
        int cDNAColumn = this.getConfig().getColumn("cDNA_ID");
        int countColumn = this.getConfig().getColumn("Count");
                
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            CellBase base = (CellBase)this.getValueAt(r,cDNAColumn);
            String cellcDNA = base.getValueAsString();
            if (cellcDNA.equals("") || !cellcDNA.equals(cDNA)) continue;
            
            String cellCount = ((CellBase)this.getValueAt(r,countColumn)).getValueAsString();
            if (cellCount.equals(""))continue;
            int numberValue = Integer.valueOf(cellCount);
            if (max < numberValue) max = numberValue;
        }
        return max+1;
    }    
}
