/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.miseq;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.FlyMiSeqModel;
import org.rhwlab.LMS.models.MiSeqModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class cDNACount extends IntegerCell  {
    public cDNACount(){
        this("");
    }
    public cDNACount(String id){
        super(id);
        inputs.put("cDNA_ID",null);
    }    
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = (CellBase)inputs.get("cDNA_ID");
        if (base == null)return;
        String sample = base.getValueAsString();
        if (sample.equals("")) return;
        int count = 0;
        // get the next design value
        if (this.getModel() instanceof MiSeqModel){
            MiSeqModel miseqModel = (MiSeqModel)this.getModel();

            try {
                count = miseqModel.nextCount(sample,this.getRow());
            }catch(Exception exc){exc.printStackTrace();
            }
        } else if (this.getModel() instanceof FlyMiSeqModel){
            FlyMiSeqModel miseqModel = (FlyMiSeqModel)this.getModel();

            try {
                count = miseqModel.nextCount(sample,this.getRow());
            }catch(Exception exc){exc.printStackTrace();
            }
        }
        this.setValue(Integer.toString(count));
        this.unlock();
        
        
    }       
}
