/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.imaging;

import java.io.File;
import java.io.FilenameFilter;
import org.rhwlab.db.beans.Imaged;

/**
 *
 * @author gevirl
 */
// load up the Imaged table from the embryoDB xmls
public class LoadDB {
    // this updates the database using all the xml
    static public void updateFromXML() throws Exception {
        // read each entry in the embryodb directory and update the database
        File directory = new File("/nfs/waterston/embryoDB");
        File[] xmls = directory.listFiles(new FilenameFilter(){
            public boolean accept(File dir,String name){
                if (name.endsWith(".xml")) {
                    return true;
                }
                return false;
            }
        });

        Imaged imaged = new Imaged();
        for (File xml : xmls){
            System.out.println(xml.getName());
            try {
                imaged.fromXML(xml);
                imaged.fromStrainSQL();
                imaged.updateDB();
            } catch (Exception exc){
                exc.printStackTrace();
 //               System.exit(1);
            }
        }
    }    
    static public void main(String[] args) throws Exception {
        updateFromXML();
    }
}
