/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.imaging;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.ImagingModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ImagedCount extends IntegerCell {
    public ImagedCount(){
        this("");
    }
    public ImagedCount(String id){
        super(id);
        inputs.put("StrainID",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = inputs.get("StrainID");
        if (base != null){
            String strain = base.getValueAsString();

            // get the next design value
            ImagingModel imageModel = (ImagingModel)this.getModel();
            int n = 0;
            try {
                n = imageModel.nextImageCount(strain,this.getRow());
            }catch(Exception exc){exc.printStackTrace();}

            this.setValue(Integer.toString(n));
            this.unlock();
        }
    }     
}
