/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.hiseq;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.HiSeqModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class cDNACount extends IntegerCell  {
    public cDNACount(){
        this("");
    }
    public cDNACount(String id){
        super(id);
        inputs.put("cDNA_ID",null);
    }    
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = (CellBase)inputs.get("cDNA_ID");
        if (base == null)return;
        String sample = base.getValueAsString();
        if (sample.equals("")) return;
        
        // get the next design value
        HiSeqModel hiseqModel = (HiSeqModel)this.getModel();
        int count = 0;
        try {
            count = hiseqModel.nextCount(sample,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(count));
        this.unlock();
        
        
    }       
}
