/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.hiseq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Md5sums extends TextCell{
    public void stateChanged(ChangeEvent ce) {
        try {
            String alignDir = ((CellBase)ce.getSource()).getValueAsString();
            File md5File = new File(new File(alignDir),"md5");
            if (md5File.exists()){
                StringBuilder builder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new FileReader(md5File));
                String line = reader.readLine();
                while (line != null){
                    builder.append(line);
                    String[] tokens = line.split("  ");
                    md5Map.put(tokens[1],tokens[0]);
                    line = reader.readLine();
                }
                reader.close();
                this.setValue(builder.toString());
            }
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    public String getMd5(String fileName){
        return md5Map.get(fileName);
    }
    TreeMap<String,String> md5Map = new TreeMap<>();
}
