/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.generation;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.GenerationModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class Generation extends IntegerCell {
    public Generation(){
        this("");
    }
    public Generation(String id){
        super(id);
        inputs.put("CrossID",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = inputs.get("CrossID");
        String crossID = base.getValueAsString();
        
        // get the next design value
        GenerationModel genModel = (GenerationModel)this.getModel();
        int n = 0;
        try {
            n = genModel.nextGeneration(crossID,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(n));
        this.unlock();
    }     
}
