/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.freeze;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.FreezeModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class FreezeNo extends IntegerCell {
    public FreezeNo(){
        this("");
    }
    public FreezeNo(String id){
        super(id);
        inputs.put("StrainID",null);
    }    
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = (CellBase)inputs.get("StrainID");
        String strain = base.getValueAsString();
        if (strain.equals("")) return;
        
        // get the next design value
        FreezeModel freezeModel = (FreezeModel)this.getModel();
        int freeze = 0;
        try {
            freeze = freezeModel.nextFreeze(strain,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(freeze));
        this.unlock();
    }    
}
