/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.embryoDB;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.kdeexpression.KDEExpressionFile;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.views.KDESeriesExpressionScroll;

/**
 *
 * @author gevirl
 */
public class ExpressionDisplay extends AbstractCellEditor implements TableCellEditor{
    public ExpressionDisplay(){
        button = new JButton("Display");
        noFuncButton = new JButton("");

        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });        
    }
    @Override
    public Object getCellEditorValue() {
        return cellObj;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        cellObj = (CellBase)value;
        Expression expCell = (Expression)cellObj;
        String cellString = (String)cellObj.getValue();
        if (cellString.equals("")){
            return noFuncButton;
        }
        
        String series = expCell.getSeries();
        dialog = new JDialog();
        dialog.setSize(new Dimension(500,300));
        Container content = dialog.getContentPane();
        try {
            SeriesEmbryo raw = new SeriesEmbryo(MySql.getMySql(),series,"raw");
            SeriesEmbryo zblot = new SeriesEmbryo(MySql.getMySql(),series,"zblot");
            KDEExpressionFile kdeFile = new KDEExpressionFile(expCell.getFile());
            KDESeriesExpressionScroll seriesPanel = new KDESeriesExpressionScroll(zblot,raw,kdeFile);
            content.add(seriesPanel);
        } catch (Exception exc){
            exc.printStackTrace();
        }

        
        return button;
    }
    JDialog dialog;
    CellBase cellObj;  
    JButton button; 
    JButton noFuncButton;
}
