/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class TrackingFilterDialog extends JDialog {
    public TrackingFilterDialog(String[] inits){
        super(LabMan.labMan,true);
        boxPanel =   new CheckBoxPanel(inits);
        wherePanel = new WhereClausePanel();
        add(boxPanel,BorderLayout.WEST);
        add(wherePanel,BorderLayout.CENTER);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok = true;
                TrackingFilterDialog.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok = false;
                TrackingFilterDialog.this.setVisible(false);
            }
        });        
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        add(buttonPanel,BorderLayout.SOUTH);
        
    }
    public boolean isOK(){
        return ok;
    }
    public String[] getSelected(){
        return boxPanel.getSelected();
    }
    public String getWhereClause(){
        return wherePanel.getCommand();
    }
    public void setConfig(SpreadSheet config){
        wherePanel.setConfig(config);
    }
    boolean ok = false;
    CheckBoxPanel boxPanel;
    WhereClausePanel wherePanel;
}
