/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.spreadsheet.config.GridSubmission;

/**
 *
 * @author gevirl
 */
public class GridSubmitParametersDialog extends JDialog {
    public GridSubmitParametersDialog(GridSubmission gs){
        super(LabMan.labMan,"Change Grid Submission Parameters");
        this.setSize(300, 200);
        this.setLayout(new BorderLayout(3,3));
        panel = new GridSubmitParametersPanel(gs);
        this.cores = gs.getCores();
        this.hours = gs.getHours();
        this.memory = gs.getMemory();
        this.queue = gs.getQueue();
        this.concurrent = gs.getConcurrent();
        this.arrayjob = gs.getArrayJob();
        
        this.add(panel,BorderLayout.CENTER);
        
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel,BoxLayout.X_AXIS));
        this.add(buttonsPanel,BorderLayout.SOUTH);
        
        JButton def = new JButton("Default");
        buttonsPanel.add(def);
        def.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                panel.setToDefault();
            }
        });
        
        JButton ok = new JButton("Ok");
        buttonsPanel.add(ok);
        ok.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                GridSubmitParametersDialog.this.setVisible(false);
                cores = panel.getCores();
                hours = panel.getHours();
                memory = panel.getMemory();
                queue = panel.getQueue();
                if (panel.getConcurrent()!=null){
                    concurrent = panel.getConcurrent();
                    arrayjob = panel.getArrayjob();
                }
            }
        });
        
        JButton cancel = new JButton("Cancel");
        buttonsPanel.add(cancel);
        cancel.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                GridSubmitParametersDialog.this.setVisible(false);
                panel.setCores(cores);
                panel.setHours(hours);
                panel.setMemory(memory);
                panel.setQueue(queue);
                panel.setConcurrent(concurrent);
                panel.setArrayjob(arrayjob);
            }
        });
        
    }
    public int getCores(){
        return cores;
    }
    public int getHours(){
        return hours;
    }
    public int getMemory(){
        return memory;
    }
    public String getQueue(){
        return queue;
    }
    public int getConcurrent(){
        return concurrent;
    }
    public String getArrayjob(){
        return arrayjob;
    }
    public String getProgram(){
        return panel.getProgram();
    }
    GridSubmitParametersPanel panel;
    int cores;
    int memory;
    int hours;
    String queue;
    String arrayjob;
    int concurrent;
}
