/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.rhwlab.LMS.RNASeq.GeneCountFeatureGroup;
import org.rhwlab.LMS.RNASeq.TpmFeatureGroup;
import org.rhwlab.LMS.RNASeq.merged.ExpressionID;
import org.rhwlab.LMS.views.RNASeq.MergedExpressionPanel;
import org.rhwlab.gene.model.Annotation;
import org.rhwlab.gene.model.ModelFromGFF;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class ExportCountsDialog extends JDialog implements ActionListener{
    public ExportCountsDialog(SpreadSheetPanel panel){
        this.sourcePanel = panel;
        this.setTitle("Export Gene Count Values");
        
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel,BoxLayout.X_AXIS));
        filePanel.add(new JLabel("Output File: "));
        filePanel.add(outFileField);
        JButton browseButton  = new JButton("Browse");
        filePanel.add(browseButton);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
                if (chooser.showSaveDialog(chooser) == JFileChooser.APPROVE_OPTION){
                    File file = chooser.getSelectedFile();
                    outFileField.setText(file.getPath());
                }
            }
        });
        this.add(filePanel,BorderLayout.NORTH);
        
        
        tree = new JTree();
        JScrollPane treeScroll = new JScrollPane(tree);
        treeScroll.setBorder(new TitledBorder(new LineBorder(Color.BLACK),"Samples"));
        this.add(treeScroll,BorderLayout.CENTER);
        
        
        DefaultListModel model = new DefaultListModel();
        GeneCountFeatureGroup[] features = GeneCountFeatureGroup.values();
        for (GeneCountFeatureGroup feature : features){
            model.addElement(feature);
        }
        geneGroupList = new JList(model);
        geneGroupList.setSelectedValue(GeneCountFeatureGroup.mRNA, true);
        JScrollPane scroll = new JScrollPane(geneGroupList);
        scroll.setBorder(new TitledBorder(new LineBorder(Color.BLACK),"Features"));
        
        JPanel levelPanel = new JPanel();
        levelPanel.setLayout(new BoxLayout(levelPanel,BoxLayout.Y_AXIS));
        levelGroup = new ButtonGroup();
        levelGroup.add(multi);
        multi.setSelected(true);
        levelGroup.add(unique);
        levelPanel.add(multi);
        levelPanel.add(unique);
        
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BoxLayout(eastPanel,BoxLayout.Y_AXIS));
        eastPanel.add(scroll);
        eastPanel.add(levelPanel);
        
        this.add(eastPanel,BorderLayout.EAST);        
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BoxLayout(westPanel,BoxLayout.Y_AXIS));
        
        JPanel separaterPanel = new JPanel();
        separaterPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK),"Separater"));
        separaterPanel.setLayout(new BoxLayout(separaterPanel,BoxLayout.Y_AXIS));
        separaterPanel.add(tab);
        separaterPanel.add(comma);
        separaterPanel.add(space);
        group = new ButtonGroup();
        group.add(tab);
        group.add(comma);
        group.add(space);
        space.setSelected(true);
        westPanel.add(separaterPanel);
        
        JPanel headerPanel = new JPanel();
        headerPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), "File Header"));
        headerPanel.setLayout(new BoxLayout(headerPanel,BoxLayout.Y_AXIS));
        headerPanel.add(noHeader);
        headerPanel.add(sampleTime);
        headerPanel.add(sampleID);
        headerPanel.add(reference);
        ButtonGroup headergroup = new ButtonGroup();
        headergroup.add(noHeader);
        headergroup.add(sampleTime);
        headergroup.add(sampleID);
        headergroup.add(reference);
        noHeader.setSelected(true);     
        westPanel.add(headerPanel);
        this.add(westPanel,BorderLayout.WEST);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(500,300); 
        this.setLocationRelativeTo(this.sourcePanel);        
    }
    public void init() {
        if (top != null) top.removeAllChildren();
        
        if (sourcePanel instanceof MergedExpressionPanel){
            htseq = false;
            top = new DefaultMutableTreeNode("Expression IDs");
            MergedExpressionPanel expPanel = (MergedExpressionPanel)sourcePanel;
//            top = new DefaultMutableTreeNode("Libraries");
            int[] rows = expPanel.getConvertedSelectedRows(); 
            expIDs = new String[rows.length];
            int i=0;
            for (int row : rows){
                String expID = expPanel.getValue(row,"ExpressionID");
                if (expID.toLowerCase().contains("htseq")){
                    htseq = true;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(expID);
                top.add(node);
                expIDs[i] = expID;
                ++i;
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(top);
        tree.setModel(model);  
            
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            try {
                String f = this.outFileField.getText().trim();
                if (f.equals("")) {
                    JOptionPane.showMessageDialog(this,"Enter an output file");
                    return;
                }
                PrintStream stream = new PrintStream(f);
                if (sampleTime.isSelected()){
                    exportTimesHeader(expIDs,separator(),stream);
                }
                else if (sampleID.isSelected()){
                    exportIDsHeader(expIDs,separator(),stream);
                }
                else if (reference.isSelected()){
                    exportReferenceHeader(expIDs,separator(),stream);
                }

                String mapper = "unique";
                if (multi.isSelected()){
                    mapper = "Multimappers";
                }
                exportTimeSeriesFile((GeneCountFeatureGroup)geneGroupList.getSelectedValue(),expIDs,stream,separator(),mapper);
            }catch (Exception exc){
                exc.printStackTrace();
            }
        } 
        this.setVisible(false);
    }

    private String separator(){
        if (tab.isSelected()){
            return "\t";
        } else if (comma.isSelected()){
            return ",";
        } else if (space.isSelected()){
            return " ";
        }
        return null;
    }
    static public void exportTimesHeader(String[] expIDs,String sep,PrintStream outStream)throws Exception {
        outStream.print("Sequence,Common");
        for (String expID : expIDs){
            int time = ExpressionID.getSampleTime(expID);
            outStream.printf("%s%d",sep, time);
        }
        outStream.println();        
    }
    static public void exportReferenceHeader(String[] expIDs,String sep,PrintStream outStream)throws Exception {
        outStream.print("Sequence,Common");
        for (String expID : expIDs){
            String ref = ExpressionID.getReference(expID);
            outStream.printf("%s%s",sep, ref);
        }
        outStream.println();        
    }    
    static public void exportIDsHeader(String[] expIDs,String sep,PrintStream outStream)throws Exception {
        outStream.print("Sequence,Common");
        for (String expID : expIDs){
            outStream.printf("%s%s",sep, expID);
        }
        outStream.println();        
    }  
    static public void exportTimeSeriesFile(GeneCountFeatureGroup group,String [] expIDs,PrintStream outStream,String sep,String mapper) throws Exception {
//           ModelFromGFF gff = new ModelFromGFF(new File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));
            TreeMap<String,String[]> dataMap = new TreeMap<>();  // gene,expid -> count
            for (int i=0 ; i<expIDs.length ; ++i){
                String expID = expIDs[i];
                String infile = ExpressionID.countsExpressionFile(expID,group,mapper); 
                BufferedReader reader = new BufferedReader(new FileReader(infile));
                String line = reader.readLine();
                while (line != null){
                    String[] tokens = line.split("\t| |,");
                    String gene = String.format("%s,%s",tokens[0],tokens[1]);
                    String[] data = dataMap.get(gene);
                    if (data == null){
                        data = new String[expIDs.length];
                        dataMap.put(gene, data);
                    }
                    data[i] = tokens[2];
                    line = reader.readLine();
                }
                reader.close();
            }
            
            for (String key : dataMap.keySet()){
                String[] data = dataMap.get(key);
                outStream.printf("%s",key);
                for (String v : data){
                    if(v == null){
                        outStream.printf("%sna", sep);
                    }else {
                        outStream.printf("%s%s", sep,v);
                    }
                }
                outStream.println();
            }
    }
    
    ButtonGroup group;
    JCheckBox tab = new JCheckBox("Tab");
    JCheckBox comma = new JCheckBox("Comma");
    JCheckBox space = new JCheckBox("Space");
    
    ButtonGroup levelGroup;
    JCheckBox multi = new JCheckBox("Multimappers included");
    JCheckBox unique = new JCheckBox("Unique Mappers only");
    
    JCheckBox noHeader = new JCheckBox("None");
    JCheckBox sampleTime = new JCheckBox("Sample Times");
    JCheckBox sampleID = new JCheckBox("Sample IDs");
    JCheckBox reference = new JCheckBox("Reference");
    
    JFileChooser chooser = new JFileChooser();
    SpreadSheetPanel sourcePanel;
    JTextField outFileField = new JTextField();
    OkCancelPanel okCancel;
    DefaultMutableTreeNode top;
    String[] expIDs;
    JTree tree;
    boolean htseq;
    JList geneGroupList    ;
}

