/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class AddTimeSeriesDialog extends JDialog implements ActionListener {
    public AddTimeSeriesDialog(SpreadSheetPanel rnaSeqPanel){
        
        this.rnaSeqPanel = rnaSeqPanel;
        this.setTitle("Add an Expression Time Series");

        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        this.add(mainPanel,BorderLayout.CENTER);
        
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel,BoxLayout.X_AXIS));
        userPanel.add(new JLabel("User: "));
        userPanel.add(new JLabel(System.getProperty("user.name")));
        mainPanel.add(userPanel);
        
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel,BoxLayout.X_AXIS));
        namePanel.add(new JLabel("Time Series Name: "));
        namePanel.add(nameField);
        mainPanel.add(namePanel);
        
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel,BoxLayout.X_AXIS));
        descPanel.add(new JLabel("Description: "));
        descPanel.add(descField);
        mainPanel.add(descPanel);
        
        JPanel repPanel = new JPanel();
        repPanel.setLayout(new BoxLayout(repPanel,BoxLayout.Y_AXIS));
        repPanel.add(new JLabel("Expression IDs"));
        jList = new JList();
        JScrollPane scroll = new JScrollPane(jList);
        repPanel.add(scroll);
        mainPanel.add(repPanel);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(200,200);    
        this.setLocationRelativeTo(this.rnaSeqPanel);
    }
    public void init(){
        int[] rows = rnaSeqPanel.getConvertedSelectedRows();
        DefaultListModel listModel = new DefaultListModel();
        for (int row : rows){
            listModel.addElement(rnaSeqPanel.getValue(row,"ExpressionID"));
        } 
        jList.setModel(listModel);
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            // is there a condition name
            String condName = nameField.getText().trim();
            if (condName.equals("")){
                JOptionPane.showMessageDialog(this, "Enter and identifier for this time series");
                return;
            }
            // add a new row to the Time Series table
            SpreadSheetPanel tsPanel  = rnaSeqPanel.getConfig().getPanel("org.rhwlab.LMS.views.TimeSeriesPanel");
            if (tsPanel != null){
                SpreadSheetModel tsModel = tsPanel.getModel();
                int tsRow = tsModel.addEmptyRow();
                tsPanel.moveToRow(tsRow);
                tsModel.setValue(tsRow,"Name", nameField.getText().trim(), true);
                tsModel.setValue(tsRow,"Description", descField.getText().trim(), true);
                ListModel listModel = jList.getModel();
                int n = listModel.getSize();
                
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (int i=0 ; i<n ; ++i){
                    arrayBuilder.add((String)listModel.getElementAt(i));
                }
                tsModel.setValue(tsRow,"ExpressionIDs",arrayBuilder.build(), true);
            }
            
        } else {
            
        }
        this.setVisible(false);
    }
    SpreadSheetPanel rnaSeqPanel;  // the parent panel of this dialog
    JList jList;
    OkCancelPanel okCancel;
    JTextField nameField = new JTextField();
    JTextField descField = new JTextField();
}
