/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.LMS.views.RNASeqSamplePanel;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class AddDataSetDialog extends JDialog implements ActionListener {
    public AddDataSetDialog(RNASeqSamplePanel samplePanel){
        super(LabMan.labMan,true);
        this.samplePanel = samplePanel;
        this.setTitle("Add a DataSet of Samples");
        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        this.add(mainPanel,BorderLayout.CENTER);
        
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel,BoxLayout.X_AXIS));
        userPanel.add(new JLabel("User: "));
        userPanel.add(new JLabel(System.getProperty("user.name")));
        mainPanel.add(userPanel);
        
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel,BoxLayout.X_AXIS));
        namePanel.add(new JLabel("DataSet Name: "));
        namePanel.add(nameField);
        mainPanel.add(namePanel);
        
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel,BoxLayout.X_AXIS));
        descPanel.add(new JLabel("Description: "));
        descPanel.add(descField);
        mainPanel.add(descPanel);
        
        JPanel repPanel = new JPanel();
        repPanel.setLayout(new BoxLayout(repPanel,BoxLayout.Y_AXIS));
        repPanel.add(new JLabel("Samples:"));
        jList = new JList();
        JScrollPane scroll = new JScrollPane(jList);
        repPanel.add(scroll);
        mainPanel.add(repPanel);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(200,200); 
        this.setLocationRelativeTo(this.samplePanel);
    }
    public void init(){
        int[] rows = samplePanel.getConvertedSelectedRows();
        
        DefaultListModel listModel = new DefaultListModel();
        for (int row : rows){
            listModel.addElement(samplePanel.getValue(row,"SampleID"));
        } 
        jList.setModel(listModel);
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            okAction();
        }
        this.setVisible(false);
    }
    public String okAction(){
        // is there a condition name
        String datasetName = nameField.getText().trim();
        if (datasetName.equals("")){
            JOptionPane.showMessageDialog(this, "Enter a dataset name for these samples");
            return "";
        }
        // add a new row to the Dataset table
        SpreadSheetPanel datasetPanel  = samplePanel.getConfig().getPanel("org.rhwlab.LMS.views.DatasetPanel");
        if (datasetPanel != null){
            SpreadSheetModel datasetModel = datasetPanel.getModel();
            int datasetRow = datasetModel.addEmptyRow();
            datasetPanel.moveToRow(datasetRow);
            datasetModel.setValue(datasetRow,"DataSetName", nameField.getText().trim(), true);
            datasetModel.setValue(datasetRow,"Description", descField.getText().trim(), true);
            ListModel listModel = jList.getModel();
            int n = listModel.getSize();

            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int i=0 ; i<n ; ++i){
                arrayBuilder.add((String)listModel.getElementAt(i));
            }
            datasetModel.setValue(datasetRow,"Samples",arrayBuilder.build(), true);
            
            dataSetID = datasetPanel.getValue(datasetRow,"DataSetID");
            return dataSetID;
        } 
        return "";
    }
    public void setDataSetName(Object obj){
        nameField.setText(((String)obj).trim());
    }
    public void setDescription(Object obj){
        descField.setText(((String)obj).trim());
    }  
    public String getDataSetID(){
        return this.dataSetID;
    }
    public boolean isOK(){
        return this.okCancel.isOK();
    }
    JsonObject conditions;
    RNASeqSamplePanel samplePanel;
    JList jList;
    OkCancelPanel okCancel;
    JTextField nameField = new JTextField();
    JTextField descField = new JTextField();
    String dataSetID;
}
