/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dialogs;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.rhwlab.LMS.RNASeq.ConditionID;
import org.rhwlab.LMS.views.ConditionPanel;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;

/**
 *
 * @author gevirl
 */
public class AddAnalysisDialog extends JDialog implements ActionListener {
    public AddAnalysisDialog(ConditionPanel conditionPanel){
        this.conditionPanel = conditionPanel;
        this.setTitle("Add an Analysis");

        
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        this.add(mainPanel,BorderLayout.CENTER);
        
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel,BoxLayout.X_AXIS));
        userPanel.add(new JLabel("User: "));
        userPanel.add(new JLabel(System.getProperty("user.name")));
        mainPanel.add(userPanel);
        
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel,BoxLayout.X_AXIS));
        namePanel.add(new JLabel("Analysis: "));
        namePanel.add(nameField);
        mainPanel.add(namePanel);
        
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel,BoxLayout.X_AXIS));
        descPanel.add(new JLabel("Description: "));
        descPanel.add(descField);
        mainPanel.add(descPanel);
        
        JPanel repPanel = new JPanel();
        repPanel.setLayout(new BoxLayout(repPanel,BoxLayout.Y_AXIS));
        repPanel.add(new JLabel("Conditions:"));
        jList = new JList();
        JScrollPane scroll = new JScrollPane(jList);
        repPanel.add(scroll);
        mainPanel.add(repPanel);
        
        okCancel = new OkCancelPanel();
        okCancel.addActionListener(this);
        this.add(okCancel,BorderLayout.SOUTH);
        this.setSize(200,200); 
        this.setLocationRelativeTo(this.conditionPanel);
    }
    public void init()throws Exception {
        int[] rows = conditionPanel.getConvertedSelectedRows();
        JsonObjectBuilder objBuilder = Json.createObjectBuilder();
        DefaultListModel listModel = new DefaultListModel();
        String condID = null;
        for (int row : rows){
            condID = conditionPanel.getValue(row,"ConditionID");
            objBuilder.add(condID, (JsonValue)conditionPanel.getValueAsObject(row,"Replicates"));
            listModel.addElement(condID);
        } 
        conditions = objBuilder.build();
        reference = ConditionID.getReference(condID);
        jList.setModel(listModel);
    }
    @Override
    public void actionPerformed(ActionEvent e) {
        if (okCancel.isOK()){
            String analysisName = nameField.getText().trim();
            if (analysisName.equals("")){
                JOptionPane.showMessageDialog(this,"Enter an Analysis identifier");
                return;
            }
            // add a new row to the Analysis table
            SpreadSheetPanel analysisPanel  = conditionPanel.getConfig().getPanel("org.rhwlab.LMS.views.AnalysisPanel");
            if (analysisPanel != null){
                SpreadSheetModel analysisModel = analysisPanel.getModel();
                int analysisRow = analysisModel.addEmptyRow();
                analysisPanel.moveToRow(analysisRow);
                analysisModel.setValue(analysisRow,"Analysis", nameField.getText().trim(), true);
                analysisModel.setValue(analysisRow,"Description", descField.getText().trim(), true);
                ListModel listModel = jList.getModel();
                int n = listModel.getSize();

                analysisModel.setValue(analysisRow,"Conditions",conditions, true);
                analysisModel.setValue(analysisRow,"Reference",reference, true);
            }
            
        } else {
            
        }
        this.setVisible(false);
    }
    String reference;
    JsonObject conditions;
    ConditionPanel conditionPanel;
    JList jList;
    OkCancelPanel okCancel;
    JTextField nameField = new JTextField();
    JTextField descField = new JTextField();
}
