/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import java.io.File;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class Segmenting extends Status implements GridSubmittable {
    public Segmenting(){
        super();
        inputs.put("Directory", null);
        inputs.put("diSPIMID", null); 
        inputs.put("Deconvolution",null);
        inputs.put("TimePoints",null);
        inputs.put("Lineaging",null);
    }
/*    
    public void submit()throws Exception {
        String decon = inputs.get("Deconvolution").getValueAsString();
        if (decon.equals("")){
            JOptionPane.showMessageDialog(this.panel,"Need to run the Deconvolution first ");
            return;
        }
        String dir = inputs.get("Directory").getValueAsString();
        String diSPIM_ID = inputs.get("diSPIMID").getValueAsString();
        File scriptFile = makeScript(diSPIM_ID,dir);
        // start the script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile.getPath());
        Process p = pb.start(); 
        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Segmentation = ? where diSPIMID = ?");
        state.setString(1, "Started");
        state.setString(2,diSPIM_ID);
        state.execute();  
        this.setValue("Started");         
    }
    private File makeScript(String diSPIM_ID,String dir)throws Exception {
        String tps = inputs.get("TimePoints").getValueAsString();
        
        File qsubFile = makeQsub(diSPIM_ID,dir);
        File scriptFile = new File(dir,"Segmentation.sh");
        
        PrintStream writer = new PrintStream(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -binding linear_automatic:2 -pe serial 2 -l mfree=2G -l h_rt=48:0:0  -e %s -o %s -t 1-%s -tc 200 %s\n",dir,dir,tps,qsubFile.getPath());
//        writer.printf("/nfs/waterston/jdk1.8.0_102/bin/java -Xms3G -Xmx3G -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.diSPIM.Segmentation %s \n",diSPIM_ID);          
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);        
        return scriptFile;
    }
    private File makeQsub(String diSPIM_ID,String dir)throws Exception {
        Integer line  = ((Lineaging)inputs.get("Lineaging")).mvrCode();
        // write the qsub file
        File qsubFile = new File(dir,"Segmentation.qsub");
        qsubFile.setWritable(true,false);
        PrintStream qsubStream = new PrintStream(qsubFile);
        qsubStream.println("#$ -S /bin/bash");
        qsubStream.println("cd /nfs/waterston/ilastik-1.1.9-Linux ");
        qsubStream.printf("LAZYFLOW_THREADS=2 LAZYFLOW_TOTAL_RAM_MB=2000 ./run_ilastik.sh --headless --project=/nfs/waterston/ilastik-1.1.9-Linux/10iterations.ilp"
                + " --export_source='Probabilities' --output_format='hdf5' --export_dtype=float32  %s/MVR_STACKS/TP${SGE_TASK_ID}_Ch%s_Ill0_Ang0,90.tif",dir,line);

      
        qsubStream.close();
        return qsubFile;        
    } 
    
    // entry point to update database after Interest point and registration completed
    static public void main(String[] args) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Segmentation = ? where diSPIMID = ?");
        state.setString(1, "Completed");
        state.setString(2, args[0]);
        
        state.execute();
    }
*/
    @Override
    public void submit(String prog,int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        Integer line  = ((Lineaging)inputs.get("Lineaging")).mvrCode();
        String decon = inputs.get("Deconvolution").getValueAsString();
        if (decon.equals("")){
            JOptionPane.showMessageDialog(this.panel,"Need to run the Deconvolution first ");
            return;
        }
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String diSPIM_ID = inputs.get("diSPIMID").getValueAsString();
        
        GridSubmit gs = new GridSubmit(diSPIM_ID,"Segmenting",dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        gs.setArrayjob(arrayjob);
        gs.setConcurrent(concurrent);
        
        PrintWriter qsubStream = gs.initializeQsub();  
        qsubStream.println("cd /nfs/waterston/ilastik-1.1.9-Linux ");
        qsubStream.printf("LAZYFLOW_THREADS=2 LAZYFLOW_TOTAL_RAM_MB=2000 ./run_ilastik.sh --headless --project=/nfs/waterston/ilastik-1.1.9-Linux/10iterations.ilp"
                + " --export_source='Probabilities' --output_format='hdf5' --export_dtype=float32  %s/MVR_STACKS/TP${SGE_TASK_ID}_Ch%s_Ill0_Ang0,90.tif",dir,line);
        gs.run();
    }
}
