/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import java.io.File;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class PreProcessor extends Status implements GridSubmittable {
    public PreProcessor(){
        super();
        inputs.put("Directory", null);
        inputs.put("PreprocessorArgs", null);
        inputs.put("diSPIMID", null);
    }
    public void submit()throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        if (dir.equals("")){
            JOptionPane.showMessageDialog(this.panel,"Specify ImagedDate to set Name and Directory ");
            return;
        }
        
        String args = inputs.get("PreprocessorArgs").getValueAsString();
        if (args.equals("")){
            JOptionPane.showMessageDialog(panel, "Enter the PreprocessorArgs");
            return;
        }
        
        String diSPIM_ID = inputs.get("diSPIMID").getValueAsString();
        
        File scriptFile = makeScript(diSPIM_ID,dir,args);

        // start the script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile.getPath());
        Process p = pb.start();  
        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Preprocessing= ? where diSPIMID = ?");
        state.setString(1, "Started");
        state.setString(2,diSPIM_ID);
        state.execute();  
        this.setValue("Started");
    }
    private File makeScript(String diSPIM_ID,String dir,String args)throws Exception {

        File qsubFile = makeQsub(diSPIM_ID,dir,args);
        File scriptFile = new File(dir,"Preprocessor.sh");
        
        PrintStream writer = new PrintStream(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -e %s -o %s %s\n",dir,dir,qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);        
        return scriptFile;
    }
    private File makeQsub(String diSPIM_ID,String dir,String args)throws Exception {
        // write the qsub file
        File qsubFile = new File(dir,"Preprocessor.qsub");
        qsubFile.setWritable(true,false);
        PrintStream qsubStream = new PrintStream(qsubFile);
        qsubStream.println("#$ -S /bin/bash");
        qsubStream.printf("#$ -l mfree=3G\n");
        qsubStream.println("#$ -l h_rt=9:0:0");
        qsubStream.printf("cd %s\n", dir);
        qsubStream.printf("/nfs/waterston/jdk1.8.0_102/bin/java -Xms3G -Xmx3G -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.diSPIM.DiSPIM_preprocessor %s %s \n",diSPIM_ID,args);
        qsubStream.close();
        return qsubFile;        
    }

    @Override
    public void submit(String prog,int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        if (dir.equals("")){
            JOptionPane.showMessageDialog(this.panel,"Specify ImagedDate to set Name and Directory ");
            return;
        }
        File dirFile = new File(dir);
        
        String args = inputs.get("PreprocessorArgs").getValueAsString();
        if (args.equals("")){
            JOptionPane.showMessageDialog(panel, "Enter the PreprocessorArgs");
            return;
        }
        
        String diSPIM_ID = inputs.get("diSPIMID").getValueAsString();
        
        GridSubmit gs = new GridSubmit(diSPIM_ID,"Preprocessor",dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        
        gs.initializeQsub();   
        ArrayList<String> argsList = new ArrayList();
        argsList.add(diSPIM_ID);
        argsList.add(args);
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.diSPIM.DiSPIM_preprocessor", argsList);
        

        gs.run(); 

        PreparedStatement state = MySql.getMySql().getStatement("Update diSPIM set Preprocessing= ? where diSPIMID = ?");
        state.setString(1, "Started");
        state.setString(2,diSPIM_ID);
        state.execute();  
        this.setValue("Started");        
        
    }
}
