/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.diSPIM;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.json.JsonObject;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.JsonCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class BHCID extends TextCell implements GridSubmittable {
    public BHCID(){
        super();
        inputs.put("Name",null);
        inputs.put("Time",null);
        inputs.put("SegProb",null);
        inputs.put("BHCDirectory",null);
        inputs.put("Variance",null);
        inputs.put("DegreesFreedom",null);
        inputs.put("Log Conc",null);
        inputs.put("Lineaging",null);
        inputs.put("Bounding",null);

    }
    public void stateChanged(ChangeEvent event){
        String name = inputs.get("Name").getValueAsString();
        String time = inputs.get("Time").getValueAsString();
        String segProb = inputs.get("SegProb").getValueAsString();
        
        if (name.equals("")||time.equals("")||segProb.equals("")) return;
        
        this.setValue(formID(name,time,segProb));
    }
    public static String formID(String name,String time,String segProb) {
        return String.format("%s_%s_%s",name,time,segProb);
    } 
    public static String formID(String name,int time,int prob){
        return formID(name,Integer.toString(time),Integer.toString(prob));
    }


    @Override
    public void submit(String prog,int cores, int memory, int hours, String queue,String arrayjob,int concurrent) throws Exception  {
        String dir =inputs.get("BHCDirectory").getValueAsString();
        
        String lineage = Directory.getLineaging(dir);
        File dirFile = new File(dir);
        int ch = 2;
        if (lineage.equals("GFP")){
            ch = 1;
        }
        
        String time = inputs.get("Time").getValueAsString();

        ArrayList<String> argsList = new ArrayList<>();
        argsList.add(String.format("-segThresh %s", inputs.get("SegProb").getValueAsString()));
        argsList.add(String.format("-S %s", inputs.get("Variance").getValueAsString()));
        argsList.add(String.format("-nu %s", inputs.get("DegreesFreedom").getValueAsString()));
        CellBase base = inputs.get("Log Conc");
        argsList.add(String.format("-logAlpha %s", base.getValueAsString()));
        argsList.add(String.format("-segTiff %s/MVR_STACKS/TP%s_Ch%d_Ill0_Ang0,90_Probabilities.h5",dirFile.getPath(),time,ch));
        argsList.add(String.format("-lineageTiff %s/MVR_STACKS/TP%s_Ch%d_Ill0_Ang0,90.tif",dirFile.getPath(),time,ch));
        argsList.add(String.format("-bhcDir %s/BHC",dirFile.getPath()));
        JsonCell bound = (JsonCell)inputs.get("Bounding");
        JsonObject json = (JsonObject)bound.getValue();
        argsList.add(String.format("-xMin %d",json.getJsonNumber("xmin").intValue()));
        argsList.add(String.format("-xMax %d",json.getJsonNumber("xmax").intValue()));
        argsList.add(String.format("-yMin %d",json.getJsonNumber("ymin").intValue()));
        argsList.add(String.format("-yMax %d",json.getJsonNumber("ymax").intValue()));
        argsList.add(String.format("-zMin %d",json.getJsonNumber("zmin").intValue()));
        argsList.add(String.format("-zMax %d",json.getJsonNumber("zmax").intValue()));        
        
        GridSubmit gs = new GridSubmit(this.getValueAsString(),"BHC",dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        
        gs.initializeQsub();
        String mainClass = "org.rhwlab.BHC.Nuclei_Identification";
        
        gs.runJavaClass("/nfs/waterston/tools3/Ace-3D.jar",mainClass, argsList);
        //
        
        gs.run();
    }
}
