/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.coreg;

import java.util.List;
import java.util.TreeSet;
import org.rhwlab.gene.model.Annotation;

/**
 *
 * @author gevirl
 */
public class GenePair implements Comparable {
    public GenePair(Annotation low,Annotation high,String cat,double d,int gd){
        this.lowGene = low;
        this.highGene = high;
        this.category = cat;
        this.expDistance = d;
        this.genomicDistance = gd;
    }
    static public double[] getExpDistance(TreeSet<GenePair> pairs){
        double[] ret = new double[pairs.size()];
        int i = 0;
        for (GenePair pair : pairs){
            ret[i] = pair.expDistance;
            ++i;
        }
        return ret;
    }
    static public int[] getGenomicDistance(TreeSet<GenePair> pairs){
        int[] ret = new int[pairs.size()];
        int i =0;
        for (GenePair pair : pairs){
            ret[i] = pair.genomicDistance;
            ++i;
        }
        return ret;
    }    
    Annotation lowGene;
    Annotation highGene;
    double expDistance;
    int genomicDistance;
    String category;

    @Override
    public int compareTo(Object o) {
        GenePair other = (GenePair)o;
        
        int ret = this.lowGene.getGeneID().compareTo(other.lowGene.getGeneID());
        if (ret != 0) return ret; // different low genes
        
        return this.highGene.getGeneID().compareTo(other.highGene.getGeneID());
    }
}
